#! /bin/sh
# check script for Xlunzip - Test tool for the lzip_decompress linux module
# Copyright (C) 2016-2021 Antonio Diaz Diaz.
#
# This script is free software: you have unlimited permission
# to copy, distribute, and modify it.

LC_ALL=C
export LC_ALL
objdir=`pwd`
testdir=`cd "$1" ; pwd`
LZIP="${objdir}"/xlunzip
framework_failure() { echo "failure in testing framework" ; exit 1 ; }

if [ ! -f "${LZIP}" ] || [ ! -x "${LZIP}" ] ; then
	echo "${LZIP}: cannot execute"
	exit 1
fi

[ -e "${LZIP}" ] 2> /dev/null ||
	{
	echo "$0: a POSIX shell is required to run the tests"
	echo "Try bash -c \"$0 $1 $2\""
	exit 1
	}

if [ -d tmp ] ; then rm -rf tmp ; fi
mkdir tmp
cd "${objdir}"/tmp || framework_failure

cat "${testdir}"/test.txt > in || framework_failure
in_lz="${testdir}"/test.txt.lz
in_em="${testdir}"/test_em.txt.lz
fox_lz="${testdir}"/fox.lz
zero_lz="${testdir}"/zero.lz
fail=0
test_failed() { fail=1 ; printf " $1" ; [ -z "$2" ] || printf "($2)" ; }

printf "testing xlunzip-%s..." "$2"

"${LZIP}" -tq in
[ $? = 2 ] || test_failed $LINENO
"${LZIP}" -tq < in
[ $? = 2 ] || test_failed $LINENO
"${LZIP}" -cdq in
[ $? = 2 ] || test_failed $LINENO
"${LZIP}" -cdq < in
[ $? = 2 ] || test_failed $LINENO
"${LZIP}" -dq -o in < "${in_lz}"
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -dq -o in "${in_lz}"
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -dq -o out nx_file.lz
[ $? = 1 ] || test_failed $LINENO
[ ! -e out ] || test_failed $LINENO
# these are for code coverage
"${LZIP}" -t -- nx_file.lz 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -t "" < /dev/null 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" --help > /dev/null || test_failed $LINENO
"${LZIP}" -n1 -V > /dev/null || test_failed $LINENO
"${LZIP}" -m 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -z 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" --bad_option 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" --t 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" --test=2 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" --output= 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" --output 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
printf "LZIP\001-.............................." | "${LZIP}" -t 2> /dev/null
printf "LZIP\002-.............................." | "${LZIP}" -t 2> /dev/null
printf "LZIP\001+.............................." | "${LZIP}" -t 2> /dev/null

printf "\ntesting decompression..."

for i in "${in_lz}" "${in_em}" ; do
	"${LZIP}" -t "$i" || test_failed $LINENO "$i"
	"${LZIP}" -d "$i" -o copy || test_failed $LINENO "$i"
	cmp in copy || test_failed $LINENO "$i"
	"${LZIP}" -cd "$i" > copy || test_failed $LINENO "$i"
	cmp in copy || test_failed $LINENO "$i"
	"${LZIP}" -d "$i" -o - > copy || test_failed $LINENO "$i"
	cmp in copy || test_failed $LINENO "$i"
	"${LZIP}" -d < "$i" > copy || test_failed $LINENO "$i"
	cmp in copy || test_failed $LINENO "$i"
	rm -f copy || framework_failure
done

cat "${in_lz}" > copy.lz || framework_failure
"${LZIP}" -dk copy.lz || test_failed $LINENO
cmp in copy || test_failed $LINENO
printf "to be overwritten" > copy || framework_failure
"${LZIP}" -d copy.lz 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -df copy.lz || test_failed $LINENO
[ ! -e copy.lz ] || test_failed $LINENO
cmp in copy || test_failed $LINENO

printf "to be overwritten" > copy || framework_failure
"${LZIP}" -d -o copy < "${in_lz}" 2> /dev/null
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -df -o copy < "${in_lz}" || test_failed $LINENO
cmp in copy || test_failed $LINENO
rm -f out copy || framework_failure
"${LZIP}" -d -o ./- "${in_lz}" || test_failed $LINENO
cmp in ./- || test_failed $LINENO
rm -f ./- || framework_failure
"${LZIP}" -d -o ./- < "${in_lz}" || test_failed $LINENO
cmp in ./- || test_failed $LINENO
rm -f ./- || framework_failure

cat "${in_lz}" > anyothername || framework_failure
"${LZIP}" -dv - anyothername - < "${in_lz}" > copy 2> /dev/null ||
	test_failed $LINENO
cmp in copy || test_failed $LINENO
cmp in anyothername.out || test_failed $LINENO
rm -f copy anyothername.out || framework_failure

"${LZIP}" -tq in "${in_lz}"
[ $? = 2 ] || test_failed $LINENO
"${LZIP}" -tq nx_file.lz "${in_lz}"
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -cdq in "${in_lz}" > copy
[ $? = 2 ] || test_failed $LINENO
cat copy in | cmp in - || test_failed $LINENO
"${LZIP}" -cdq nx_file.lz "${in_lz}" > copy
[ $? = 1 ] || test_failed $LINENO
cmp in copy || test_failed $LINENO
rm -f copy || framework_failure
cat "${in_lz}" > copy.lz || framework_failure
"${LZIP}" -dq in copy.lz
[ $? = 2 ] || test_failed $LINENO
[ -e copy.lz ] || test_failed $LINENO
[ ! -e copy ] || test_failed $LINENO
[ ! -e in.out ] || test_failed $LINENO
"${LZIP}" -dq nx_file.lz copy.lz
[ $? = 1 ] || test_failed $LINENO
[ ! -e copy.lz ] || test_failed $LINENO
[ ! -e nx_file ] || test_failed $LINENO
cmp in copy || test_failed $LINENO

cat in in > in2 || framework_failure
"${LZIP}" -t "${in_lz}" "${in_lz}" || test_failed $LINENO
"${LZIP}" -cd "${in_lz}" "${in_lz}" -o out > copy2 || test_failed $LINENO
[ ! -e out ] || test_failed $LINENO			# override -o
cmp in2 copy2 || test_failed $LINENO
rm -f copy2 || framework_failure
"${LZIP}" -d "${in_lz}" "${in_lz}" -o copy2 || test_failed $LINENO
cmp in2 copy2 || test_failed $LINENO
rm -f copy2 || framework_failure

cat "${in_lz}" "${in_lz}" > copy2.lz || framework_failure
printf "\ngarbage" >> copy2.lz || framework_failure
"${LZIP}" -tvvvv copy2.lz 2> /dev/null || test_failed $LINENO
printf "to be overwritten" > copy2 || framework_failure
"${LZIP}" -df copy2.lz || test_failed $LINENO
cmp in2 copy2 || test_failed $LINENO

printf "\ntesting bad input..."

headers='LZIp LZiP LZip LzIP LzIp LziP lZIP lZIp lZiP lzIP'
body='\001\014\000\203\377\373\377\377\300\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000$\000\000\000\000\000\000\000'
cat "${in_lz}" > int.lz
printf "LZIP${body}" >> int.lz
if "${LZIP}" -tq int.lz ; then
	for header in ${headers} ; do
		printf "${header}${body}" > int.lz	# first member
		"${LZIP}" -tq int.lz
		[ $? = 2 ] || test_failed $LINENO ${header}
		"${LZIP}" -tq < int.lz
		[ $? = 2 ] || test_failed $LINENO ${header}
		"${LZIP}" -cdq int.lz > /dev/null
		[ $? = 2 ] || test_failed $LINENO ${header}
		cat "${in_lz}" > int.lz
		printf "${header}${body}" >> int.lz	# trailing data
		"${LZIP}" -tq int.lz
		[ $? = 2 ] || test_failed $LINENO ${header}
		"${LZIP}" -tq < int.lz
		[ $? = 2 ] || test_failed $LINENO ${header}
		"${LZIP}" -cdq int.lz > /dev/null
		[ $? = 2 ] || test_failed $LINENO ${header}
	done
else
	printf "\nwarning: skipping header test: 'printf' does not work on your system."
fi
rm -f int.lz || framework_failure

for i in fox_v2.lz fox_s11.lz fox_de20.lz \
         fox_bcrc.lz fox_crc0.lz fox_das46.lz fox_mes81.lz ; do
	"${LZIP}" -tq "${testdir}"/$i
	[ $? = 2 ] || test_failed $LINENO $i
done

"${LZIP}" -cd "${fox_lz}" > fox || test_failed $LINENO
for i in fox_bcrc.lz fox_crc0.lz fox_das46.lz fox_mes81.lz ; do
	"${LZIP}" -cdq "${testdir}"/$i > out
	[ $? = 2 ] || test_failed $LINENO $i
	cmp fox out || test_failed $LINENO $i
done
rm -f fox out || framework_failure

cat "${in_lz}" "${in_lz}" > in2.lz || framework_failure
cat "${in_lz}" "${in_lz}" "${in_lz}" > in3.lz || framework_failure
if dd if=in3.lz of=trunc.lz bs=14752 count=1 2> /dev/null &&
   [ -e trunc.lz ] && cmp in2.lz trunc.lz > /dev/null 2>&1 ; then
	for i in 6 20 14734 14753 14754 14755 14756 14757 14758 ; do
		dd if=in3.lz of=trunc.lz bs=$i count=1 2> /dev/null
		"${LZIP}" -tq trunc.lz
		[ $? = 2 ] || test_failed $LINENO $i
		"${LZIP}" -tq < trunc.lz
		[ $? = 2 ] || test_failed $LINENO $i
		"${LZIP}" -cdq trunc.lz > out
		[ $? = 2 ] || test_failed $LINENO $i
		"${LZIP}" -dq < trunc.lz > out
		[ $? = 2 ] || test_failed $LINENO $i
	done
else
	printf "\nwarning: skipping truncation test: 'dd' does not work on your system."
fi
rm -f trunc.lz out || framework_failure

cat "${in_lz}" > ingin.lz || framework_failure
printf "g" >> ingin.lz || framework_failure
cat "${in_lz}" >> ingin.lz || framework_failure
"${LZIP}" -t ingin.lz || test_failed $LINENO
"${LZIP}" -t < ingin.lz || test_failed $LINENO
"${LZIP}" -cd ingin.lz > copy || test_failed $LINENO
cmp in copy || test_failed $LINENO
"${LZIP}" -d < ingin.lz > copy || test_failed $LINENO
cmp in copy || test_failed $LINENO

printf "\ntesting linux options..."

for i in "" =1 =2 =4 =16 =64 =256 =1024 =4096 =16384 =65536 ; do
	"${LZIP}" -t --insize$i "${in_lz}" || test_failed $LINENO $i
	"${LZIP}" -cd --insize$i "${in_lz}" > copy || test_failed $LINENO $i
	cmp in copy || test_failed $LINENO $i
done

for i in =1 =2 =4 =16 =64 =256 =1024 =4096 ; do
	"${LZIP}" -tq --insize$i --nofill "${in_lz}"
	[ $? = 2 ] || test_failed $LINENO $i
	"${LZIP}" -cdq --insize$i --nofill "${in_lz}" > copy
	[ $? = 2 ] || test_failed $LINENO $i
	cmp -s in copy && test_failed $LINENO $i
done

for i in "" =16384 =65536 ; do
	"${LZIP}" -t --insize$i --nofill "${in_lz}" || test_failed $LINENO $i
	"${LZIP}" -cd --insize$i --nofill "${in_lz}" > copy ||
		test_failed $LINENO $i
	cmp in copy || test_failed $LINENO $i
done

for i in =18KiB =65536 =262144 ; do
	"${LZIP}" -t --outsize$i "${in_lz}" || test_failed $LINENO $i
	"${LZIP}" -cd --outsize$i "${in_lz}" > copy ||
		test_failed $LINENO $i
	cmp in copy || test_failed $LINENO $i
done

for i in =36388 =65536 =262144 ; do
	"${LZIP}" -t --outsize$i --noflush "${in_lz}" ||
		test_failed $LINENO $i
	"${LZIP}" -cd --outsize$i --noflush "${in_lz}" > copy ||
		test_failed $LINENO $i
	cmp in copy || test_failed $LINENO $i
done

for i in =36387 ; do
	"${LZIP}" -tq --outsize$i --noflush "${in_lz}"
	[ $? = 1 ] || test_failed $LINENO $i
	"${LZIP}" -cdq --outsize$i --noflush "${in_lz}" > copy
	[ $? = 1 ] || test_failed $LINENO $i
	cmp -s in copy && test_failed $LINENO $i
done

for i in =4096 =16384 ; do
	"${LZIP}" -tq --outsize$i --noflush "${in_lz}"
	[ $? = 2 ] || test_failed $LINENO $i
	"${LZIP}" -cdq --outsize$i --noflush "${in_lz}" > copy
	[ $? = 2 ] || test_failed $LINENO $i
	cmp -s in copy && test_failed $LINENO $i
done

"${LZIP}" -t --insize --outsize=36388 --nofill --noflush "${in_lz}" ||
	test_failed $LINENO
"${LZIP}" -cd --insize --outsize=36388 --nofill --noflush "${in_lz}" > copy ||
	test_failed $LINENO
cmp in copy || test_failed $LINENO

"${LZIP}" -tq --nofill "${in_lz}"
[ $? = 2 ] || test_failed $LINENO
"${LZIP}" -cdq --nofill "${in_lz}" > copy
[ $? = 2 ] || test_failed $LINENO
cmp -s in copy && test_failed $LINENO
"${LZIP}" -tq --noflush "${in_lz}"
[ $? = 1 ] || test_failed $LINENO
"${LZIP}" -cdq --noflush "${in_lz}" > copy
[ $? = 1 ] || test_failed $LINENO
cmp -s in copy && test_failed $LINENO

# decompress in place
rm -f copy copy2 || framework_failure
"${LZIP}" -t --in-place "${in_lz}" || test_failed $LINENO
"${LZIP}" -t --in-place < "${in_lz}" || test_failed $LINENO
"${LZIP}" -d --in-place "${in_lz}" -o copy || test_failed $LINENO
cmp in copy || test_failed $LINENO
rm -f copy || framework_failure
"${LZIP}" -d --in-place < "${in_lz}" -o copy || test_failed $LINENO
cmp in copy || test_failed $LINENO
"${LZIP}" -cd --in-place "${in_lz}" > copy || test_failed $LINENO
cmp in copy || test_failed $LINENO
"${LZIP}" -cd --in-place < "${in_lz}" > copy || test_failed $LINENO
cmp in copy || test_failed $LINENO
"${LZIP}" -t --in-place "${in_lz}" "${in_lz}" || test_failed $LINENO
"${LZIP}" -d --in-place "${in_lz}" "${in_lz}" -o copy2 || test_failed $LINENO
cmp in2 copy2 || test_failed $LINENO
"${LZIP}" -cd --in-place "${in_lz}" "${in_lz}" > copy2 || test_failed $LINENO
cmp in2 copy2 || test_failed $LINENO

# decompress multimember in place
cat in in in > in3 || framework_failure
for i in in2 in3 ; do
	"${LZIP}" -t --in-place $i.lz || test_failed $LINENO
	"${LZIP}" -t --in-place < $i.lz || test_failed $LINENO
	rm -f copy || framework_failure
	"${LZIP}" -d --in-place $i.lz -o copy || test_failed $LINENO
	cmp $i copy || test_failed $LINENO
	rm -f copy || framework_failure
	"${LZIP}" -d --in-place < $i.lz -o copy || test_failed $LINENO
	cmp $i copy || test_failed $LINENO
	"${LZIP}" -cd --in-place $i.lz > copy || test_failed $LINENO
	cmp $i copy || test_failed $LINENO
	"${LZIP}" -cd --in-place < $i.lz > copy || test_failed $LINENO
	cmp $i copy || test_failed $LINENO
done
"${LZIP}" -tq --in-place ingin.lz
[ $? = 2 ] || test_failed $LINENO
rm -f copy copy2 ingin.lz in2 in2.lz in3 in3.lz || framework_failure

cat "${in_lz}" > inz.lz || framework_failure
counter=0
while [ ${counter} -lt 20 ] ; do
	cat "${zero_lz}" >> inz.lz || framework_failure
	"${LZIP}" -t --in-place inz.lz || test_failed $LINENO
	"${LZIP}" -cd --in-place inz.lz > copy || test_failed $LINENO
	cmp in copy || test_failed $LINENO
	counter=$((counter+1))
done
rm -f copy inz.lz || framework_failure

# decompress with trailing data in place
cat "${in_lz}" in in in in > int.lz || framework_failure
"${LZIP}" -t --in-place int.lz || test_failed $LINENO
"${LZIP}" -cd --in-place int.lz > copy || test_failed $LINENO
cmp in copy || test_failed $LINENO
rm -f copy int.lz || framework_failure

echo
if [ ${fail} = 0 ] ; then
	echo "tests completed successfully."
	cd "${objdir}" && rm -r tmp
else
	echo "tests failed."
fi
exit ${fail}
