package ONVIF::Analytics::Types::LayoutOptions;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{ # BLOCK to scope variables

my %PaneLayoutOptions_of :ATTR(:get<PaneLayoutOptions>);
my %Extension_of :ATTR(:get<Extension>);

__PACKAGE__->_factory(
    [ qw(        PaneLayoutOptions
        Extension

    ) ],
    {
        'PaneLayoutOptions' => \%PaneLayoutOptions_of,
        'Extension' => \%Extension_of,
    },
    {
        'PaneLayoutOptions' => 'ONVIF::Analytics::Types::PaneLayoutOptions',
        'Extension' => 'ONVIF::Analytics::Types::LayoutOptionsExtension',
    },
    {

        'PaneLayoutOptions' => 'PaneLayoutOptions',
        'Extension' => 'Extension',
    }
);

} # end BLOCK








1;


=pod

=head1 NAME

ONVIF::Analytics::Types::LayoutOptions

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
LayoutOptions from the namespace http://www.onvif.org/ver10/schema.

The options supported for a display layout.




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * PaneLayoutOptions


=item * Extension




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # ONVIF::Analytics::Types::LayoutOptions
   PaneLayoutOptions =>  { # ONVIF::Analytics::Types::PaneLayoutOptions
     Area => ,
     Extension =>  { # ONVIF::Analytics::Types::PaneOptionExtension
     },
   },
   Extension =>  { # ONVIF::Analytics::Types::LayoutOptionsExtension
   },
 },




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

