/* number.c generated by valac 0.40.6, the Vala compiler
 * generated from number.vala, do not modify */

/*
 * Copyright (C) 1987-2008 Sun Microsystems, Inc. All Rights Reserved.
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */
/*  This maths library is based on the MP multi-precision floating-point
 *  arithmetic package originally written in FORTRAN by Richard Brent,
 *  Computer Centre, Australian National University in the 1970's.
 *
 *  It has been converted from FORTRAN into C using the freely available
 *  f2c translator, available via netlib on research.att.com.
 *
 *  The subsequently converted C code has then been tidied up, mainly to
 *  remove any dependencies on the libI77 and libF77 support libraries.
 *
 *  FOR A GENERAL DESCRIPTION OF THE PHILOSOPHY AND DESIGN OF MP,
 *  SEE - R. P. BRENT, A FORTRAN MULTIPLE-PRECISION ARITHMETIC
 *  PACKAGE, ACM TRANS. MATH. SOFTWARE 4 (MARCH 1978), 57-70.
 *  SOME ADDITIONAL DETAILS ARE GIVEN IN THE SAME ISSUE, 71-81.
 *  FOR DETAILS OF THE IMPLEMENTATION, CALLING SEQUENCES ETC. SEE
 *  THE MP USERS GUIDE.
 */


#include <glib.h>
#include <glib-object.h>
#include "mpc.h"
#include "mpfr.h"
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>


#define TYPE_ANGLE_UNIT (angle_unit_get_type ())

#define TYPE_NUMBER (number_get_type ())
#define NUMBER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER, Number))
#define NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER, NumberClass))
#define IS_NUMBER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER))
#define IS_NUMBER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER))
#define NUMBER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER, NumberClass))

typedef struct _Number Number;
typedef struct _NumberClass NumberClass;
typedef struct _NumberPrivate NumberPrivate;
enum  {
	NUMBER_0_PROPERTY,
	NUMBER_NUM_PROPERTIES
};
static GParamSpec* number_properties[NUMBER_NUM_PROPERTIES];
typedef struct _MPFRRealRef MPFRRealRef;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

#define TYPE_SERIALIZER (serializer_get_type ())
#define SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERIALIZER, Serializer))
#define SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERIALIZER, SerializerClass))
#define IS_SERIALIZER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERIALIZER))
#define IS_SERIALIZER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERIALIZER))
#define SERIALIZER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERIALIZER, SerializerClass))

typedef struct _Serializer Serializer;
typedef struct _SerializerClass SerializerClass;

#define TYPE_DISPLAY_FORMAT (display_format_get_type ())

typedef gint (*BitwiseFunc) (gint v1, gint v2, void* user_data);
typedef enum  {
	ANGLE_UNIT_RADIANS,
	ANGLE_UNIT_DEGREES,
	ANGLE_UNIT_GRADIANS
} AngleUnit;

struct _Number {
	GObject parent_instance;
	NumberPrivate * priv;
};

struct _NumberClass {
	GObjectClass parent_class;
};

struct _NumberPrivate {
	__mpc_struct num;
};

struct _MPFRRealRef {
	__mpfr_struct val;
};

typedef enum  {
	DISPLAY_FORMAT_AUTOMATIC,
	DISPLAY_FORMAT_FIXED,
	DISPLAY_FORMAT_SCIENTIFIC,
	DISPLAY_FORMAT_ENGINEERING
} DisplayFormat;


static gpointer number_parent_class = NULL;
static mpfr_prec_t number__precision;
static mpfr_prec_t number__precision = (mpfr_prec_t) 1000;
static gchar* number__error;
static gchar* number__error = NULL;

GType angle_unit_get_type (void) G_GNUC_CONST;
GType number_get_type (void) G_GNUC_CONST;
#define NUMBER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NUMBER, NumberPrivate))
mpfr_prec_t number_get_precision (void);
Number* number_new_integer (gint64 real,
                            gint64 imag);
Number* number_construct_integer (GType object_type,
                                  gint64 real,
                                  gint64 imag);
Number* number_new_unsigned_integer (guint64 real,
                                     guint64 imag);
Number* number_construct_unsigned_integer (GType object_type,
                                           guint64 real,
                                           guint64 imag);
Number* number_new_fraction (gint64 numerator,
                             gint64 denominator);
Number* number_construct_fraction (GType object_type,
                                   gint64 numerator,
                                   gint64 denominator);
Number* number_new_mpreal (__mpfr_struct* real,
                           __mpfr_struct* imag);
Number* number_construct_mpreal (GType object_type,
                                 __mpfr_struct* real,
                                 __mpfr_struct* imag);
Number* number_new_double (gdouble real,
                           gdouble imag);
Number* number_construct_double (GType object_type,
                                 gdouble real,
                                 gdouble imag);
Number* number_new_complex (Number* r,
                            Number* i);
Number* number_construct_complex (GType object_type,
                                  Number* r,
                                  Number* i);
void mpfr_real_ref_free (MPFRRealRef * self);
Number* number_new_polar (Number* r,
                          Number* theta,
                          AngleUnit unit);
Number* number_construct_polar (GType object_type,
                                Number* r,
                                Number* theta,
                                AngleUnit unit);
Number* number_cos (Number* self,
                    AngleUnit unit);
Number* number_sin (Number* self,
                    AngleUnit unit);
Number* number_multiply (Number* self,
                         Number* y);
Number* number_new_eulers (void);
Number* number_construct_eulers (GType object_type);
Number* number_new_i (void);
Number* number_construct_i (GType object_type);
Number* number_new_pi (void);
Number* number_construct_pi (GType object_type);
Number* number_new_random (void);
Number* number_construct_random (GType object_type);
gint64 number_to_integer (Number* self);
guint64 number_to_unsigned_integer (Number* self);
gfloat number_to_float (Number* self);
gdouble number_to_double (Number* self);
gboolean number_is_zero (Number* self);
gboolean number_is_negative (Number* self);
gboolean number_is_integer (Number* self);
gboolean number_is_complex (Number* self);
gboolean number_is_positive_integer (Number* self);
gboolean number_is_natural (Number* self);
void number_check_flags (void);
const gchar* number_get_error (void);
void number_set_error (const gchar* value);
gboolean number_equals (Number* self,
                        Number* y);
gint number_compare (Number* self,
                     Number* y);
Number* number_sgn (Number* self);
Number* number_invert_sign (Number* self);
Number* number_new (void);
Number* number_construct (GType object_type);
Number* number_abs (Number* self);
Number* number_arg (Number* self,
                    AngleUnit unit);
static void number_mpc_from_radians (__mpc_struct* res,
                              __mpc_struct* op,
                              AngleUnit unit);
Number* number_conjugate (Number* self);
Number* number_real_component (Number* self);
Number* number_imaginary_component (Number* self);
Number* number_integer_component (Number* self);
Number* number_fractional_component (Number* self);
Number* number_fractional_part (Number* self);
Number* number_subtract (Number* self,
                         Number* y);
Number* number_floor (Number* self);
Number* number_ceiling (Number* self);
Number* number_round (Number* self);
Number* number_reciprocal (Number* self);
Number* number_epowy (Number* self);
Number* number_xpowy (Number* self,
                      Number* y);
Number* number_root (Number* self,
                     gint64 n);
Number* number_xpowy_integer (Number* self,
                              gint64 n);
Number* number_sqrt (Number* self);
Number* number_ln (Number* self);
Number* number_logarithm (Number* self,
                          gint64 n);
Number* number_divide (Number* self,
                       Number* y);
Number* number_factorial (Number* self);
Number* number_add (Number* self,
                    Number* y);
Number* number_multiply_integer (Number* self,
                                 gint64 y);
Number* number_divide_integer (Number* self,
                               gint64 y);
Number* number_modulus_divide (Number* self,
                               Number* y);
Number* number_modular_exponentiation (Number* self,
                                       Number* exp,
                                       Number* mod);
static Number* number_copy (Number* self);
static void number_mpc_to_radians (__mpc_struct* res,
                            __mpc_struct* op,
                            AngleUnit unit);
Number* number_tan (Number* self,
                    AngleUnit unit);
static Number* number_to_radians (Number* self,
                           AngleUnit unit);
Number* number_asin (Number* self,
                     AngleUnit unit);
Number* number_acos (Number* self,
                     AngleUnit unit);
Number* number_atan (Number* self,
                     AngleUnit unit);
Number* number_sinh (Number* self);
Number* number_cosh (Number* self);
Number* number_tanh (Number* self);
Number* number_asinh (Number* self);
Number* number_acosh (Number* self);
Number* number_atanh (Number* self);
Number* number_and (Number* self,
                    Number* y);
static Number* number_bitwise (Number* self,
                        Number* y,
                        BitwiseFunc bitwise_operator,
                        void* bitwise_operator_target,
                        gint wordlen);
static gint __lambda4_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda4__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
Number* number_or (Number* self,
                   Number* y);
static gint __lambda5_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda5__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
Number* number_xor (Number* self,
                    Number* y);
static gint __lambda6_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda6__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
Number* number_not (Number* self,
                    gint wordlen);
static gint __lambda7_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda7__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
Number* number_mask (Number* self,
                     Number* x,
                     gint wordlen);
static gchar* number_to_hex_string (Number* self);
Number* mp_set_from_string (const gchar* str,
                            gint default_base);
Number* number_shift (Number* self,
                      gint count);
Number* number_ones_complement (Number* self,
                                gint wordlen);
static gint __lambda8_ (Number* self,
                 gint v1,
                 gint v2);
static gint ___lambda8__bitwise_func (gint v1,
                               gint v2,
                               gpointer self);
Number* number_twos_complement (Number* self,
                                gint wordlen);
GList* number_factorize (Number* self);
GList* number_factorize_uint64 (Number* self,
                                guint64 n);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _mpc_equal (const __mpc_struct * s1,
                     const __mpc_struct * s2);
static gint number_hex_to_int (Number* self,
                        gchar digit);
GType serializer_get_type (void) G_GNUC_CONST;
GType display_format_get_type (void) G_GNUC_CONST;
Serializer* serializer_new (DisplayFormat format,
                            gint number_base,
                            gint trailing_digits);
Serializer* serializer_construct (GType object_type,
                                  DisplayFormat format,
                                  gint number_base,
                                  gint trailing_digits);
gchar* serializer_to_string (Serializer* self,
                             Number* x);
void number_set_precision (mpfr_prec_t value);
static void number_finalize (GObject * obj);
static void _vala_number_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec);
static void _vala_number_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec);
Number* set_from_sexagesimal (const gchar* str);
gint char_val (gunichar c,
               gint number_base);
gboolean mp_is_overflow (Number* x,
                         gint wordlen);


GType
angle_unit_get_type (void)
{
	static volatile gsize angle_unit_type_id__volatile = 0;
	if (g_once_init_enter (&angle_unit_type_id__volatile)) {
		static const GEnumValue values[] = {{ANGLE_UNIT_RADIANS, "ANGLE_UNIT_RADIANS", "radians"}, {ANGLE_UNIT_DEGREES, "ANGLE_UNIT_DEGREES", "degrees"}, {ANGLE_UNIT_GRADIANS, "ANGLE_UNIT_GRADIANS", "gradians"}, {0, NULL, NULL}};
		GType angle_unit_type_id;
		angle_unit_type_id = g_enum_register_static ("AngleUnit", values);
		g_once_init_leave (&angle_unit_type_id__volatile, angle_unit_type_id);
	}
	return angle_unit_type_id__volatile;
}


Number*
number_construct_integer (GType object_type,
                          gint64 real,
                          gint64 imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) real, (glong) imag, MPC_RNDNN);
	return self;
}


Number*
number_new_integer (gint64 real,
                    gint64 imag)
{
	return number_construct_integer (TYPE_NUMBER, real, imag);
}


Number*
number_construct_unsigned_integer (GType object_type,
                                   guint64 real,
                                   guint64 imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_ui_ui (&self->priv->num, (gulong) real, (gulong) imag, MPC_RNDNN);
	return self;
}


Number*
number_new_unsigned_integer (guint64 real,
                             guint64 imag)
{
	return number_construct_unsigned_integer (TYPE_NUMBER, real, imag);
}


Number*
number_construct_fraction (GType object_type,
                           gint64 numerator,
                           gint64 denominator)
{
	Number * self = NULL;
	if (denominator < ((gint64) 0)) {
		numerator = -numerator;
		denominator = -denominator;
	}
	self = (Number*) number_construct_integer (object_type, numerator, (gint64) 0);
	if (denominator != ((gint64) 1)) {
		mpc_div_ui (&self->priv->num, &self->priv->num, (gulong) ((glong) denominator), MPC_RNDNN);
	}
	return self;
}


Number*
number_new_fraction (gint64 numerator,
                     gint64 denominator)
{
	return number_construct_fraction (TYPE_NUMBER, numerator, denominator);
}


static gint
mpc_set_mpreal (__mpc_struct *self,
                __mpfr_struct* re,
                __mpfr_struct* im,
                mpc_rnd_t rnd)
{
	gint result = 0;
	__mpfr_struct _tmp1_;
	__mpfr_struct _tmp2_;
	g_return_val_if_fail (re != NULL, 0);
	if (im == NULL) {
		__mpfr_struct _tmp0_;
		_tmp0_ = *re;
		result = mpc_set_fr (&(*self), &_tmp0_, rnd);
		return result;
	}
	_tmp1_ = *re;
	_tmp2_ = *im;
	result = mpc_set_fr_fr (&(*self), &_tmp1_, &_tmp2_, rnd);
	return result;
}


Number*
number_construct_mpreal (GType object_type,
                         __mpfr_struct* real,
                         __mpfr_struct* imag)
{
	Number * self = NULL;
	__mpfr_struct _tmp0_;
	g_return_val_if_fail (real != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = *real;
	mpc_set_mpreal (&self->priv->num, &_tmp0_, imag, MPC_RNDNN);
	return self;
}


Number*
number_new_mpreal (__mpfr_struct* real,
                   __mpfr_struct* imag)
{
	return number_construct_mpreal (TYPE_NUMBER, real, imag);
}


Number*
number_construct_double (GType object_type,
                         gdouble real,
                         gdouble imag)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_d_d (&self->priv->num, real, imag, MPC_RNDNN);
	return self;
}


Number*
number_new_double (gdouble real,
                   gdouble imag)
{
	return number_construct_double (TYPE_NUMBER, real, imag);
}


Number*
number_construct_complex (GType object_type,
                          Number* r,
                          Number* i)
{
	Number * self = NULL;
	MPFRRealRef* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (i != NULL, NULL);
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&r->priv->num);
	_tmp1_ = mpc_realref (&i->priv->num);
	mpc_set_mpreal (&self->priv->num, &_tmp0_->val, &_tmp1_->val, MPC_RNDNN);
	return self;
}


Number*
number_new_complex (Number* r,
                    Number* i)
{
	return number_construct_complex (TYPE_NUMBER, r, i);
}


Number*
number_construct_polar (GType object_type,
                        Number* r,
                        Number* theta,
                        AngleUnit unit)
{
	Number * self = NULL;
	Number* x = NULL;
	Number* _tmp0_;
	Number* y = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (r != NULL, NULL);
	g_return_val_if_fail (theta != NULL, NULL);
	_tmp0_ = number_cos (theta, unit);
	x = _tmp0_;
	_tmp1_ = number_sin (theta, unit);
	y = _tmp1_;
	_tmp2_ = number_multiply (x, r);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_multiply (y, r);
	_tmp5_ = _tmp4_;
	self = (Number*) number_construct_complex (object_type, _tmp3_, _tmp5_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (y);
	_g_object_unref0 (x);
	return self;
}


Number*
number_new_polar (Number* r,
                  Number* theta,
                  AngleUnit unit)
{
	return number_construct_polar (TYPE_NUMBER, r, theta, unit);
}


Number*
number_construct_eulers (GType object_type)
{
	Number * self = NULL;
	MPFRRealRef* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_set_ui (&_tmp0_->val, (gulong) 1, MPFR_RNDN);
	_tmp1_ = mpc_realref (&self->priv->num);
	_tmp2_ = mpc_realref (&self->priv->num);
	mpfr_exp (&_tmp1_->val, &_tmp2_->val, MPFR_RNDN);
	_tmp3_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp3_->val, MPFR_RNDN);
	return self;
}


Number*
number_new_eulers (void)
{
	return number_construct_eulers (TYPE_NUMBER);
}


Number*
number_construct_i (GType object_type)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	mpc_set_si_si (&self->priv->num, (glong) 0, (glong) 1, MPC_RNDNN);
	return self;
}


Number*
number_new_i (void)
{
	return number_construct_i (TYPE_NUMBER);
}


Number*
number_construct_pi (GType object_type)
{
	Number * self = NULL;
	MPFRRealRef* _tmp0_;
	MPFRRealRef* _tmp1_;
	self = (Number*) g_object_new (object_type, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	mpfr_const_pi (&_tmp0_->val, MPFR_RNDN);
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	return self;
}


Number*
number_new_pi (void)
{
	return number_construct_pi (TYPE_NUMBER);
}


Number*
number_construct_random (GType object_type)
{
	Number * self = NULL;
	self = (Number*) number_construct_double (object_type, g_random_double (), (gdouble) 0);
	return self;
}


Number*
number_new_random (void)
{
	return number_construct_random (TYPE_NUMBER);
}


gint64
number_to_integer (Number* self)
{
	gint64 result = 0LL;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, 0LL);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = (gint64) mpfr_get_si (&_tmp0_->val, MPFR_RNDN);
	return result;
}


guint64
number_to_unsigned_integer (Number* self)
{
	guint64 result = 0ULL;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = (guint64) mpfr_get_ui (&_tmp0_->val, MPFR_RNDN);
	return result;
}


gfloat
number_to_float (Number* self)
{
	gfloat result = 0.0F;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0F);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_get_flt (&_tmp0_->val, MPFR_RNDN);
	return result;
}


gdouble
number_to_double (Number* self)
{
	gdouble result = 0.0;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_get_d (&_tmp0_->val, MPFR_RNDN);
	return result;
}


static gboolean
mpc_is_zero (__mpc_struct *self)
{
	gboolean result = FALSE;
	gint res = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	res = mpc_cmp_si_si (&(*self), (glong) 0, (glong) 0);
	_tmp1_ = res;
	if (MPC_INEX_RE (_tmp1_) == 0) {
		gint _tmp2_;
		_tmp2_ = res;
		_tmp0_ = MPC_INEX_IM (_tmp2_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


gboolean
number_is_zero (Number* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = mpc_is_zero (&self->priv->num);
	return result;
}


gboolean
number_is_negative (Number* self)
{
	gboolean result = FALSE;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_sgn (&_tmp0_->val) < 0;
	return result;
}


gboolean
number_is_integer (Number* self)
{
	gboolean result = FALSE;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = mpc_realref (&self->priv->num);
	result = mpfr_integer_p (&_tmp0_->val) != 0;
	return result;
}


gboolean
number_is_positive_integer (Number* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		MPFRRealRef* _tmp1_;
		_tmp1_ = mpc_realref (&self->priv->num);
		if (mpfr_sgn (&_tmp1_->val) >= 0) {
			_tmp0_ = number_is_integer (self);
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
}


gboolean
number_is_natural (Number* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (number_is_complex (self)) {
		result = FALSE;
		return result;
	} else {
		gboolean _tmp0_ = FALSE;
		MPFRRealRef* _tmp1_;
		_tmp1_ = mpc_realref (&self->priv->num);
		if (mpfr_sgn (&_tmp1_->val) > 0) {
			_tmp0_ = number_is_integer (self);
		} else {
			_tmp0_ = FALSE;
		}
		result = _tmp0_;
		return result;
	}
}


gboolean
number_is_complex (Number* self)
{
	gboolean result = FALSE;
	MPFRRealRef* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = mpc_imagref (&self->priv->num);
	result = !mpfr_zero_p (&_tmp0_->val);
	return result;
}


void
number_check_flags (void)
{
	if (mpfr_underflow_p () != 0) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Underflow error"));
	} else {
		if (mpfr_overflow_p () != 0) {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			_tmp2_ = number_get_error ();
			_tmp3_ = _tmp2_;
			number_set_error (_ ("Overflow error"));
		}
	}
}


static gboolean
mpc_is_equal (__mpc_struct *self,
              __mpc_struct* c)
{
	gboolean result = FALSE;
	gint res = 0;
	__mpc_struct _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = *c;
	res = mpc_cmp (&(*self), &_tmp0_);
	_tmp2_ = res;
	if (MPC_INEX_RE (_tmp2_) == 0) {
		gint _tmp3_;
		_tmp3_ = res;
		_tmp1_ = MPC_INEX_IM (_tmp3_) == 0;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}


gboolean
number_equals (Number* self,
               Number* y)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (y != NULL, FALSE);
	result = mpc_is_equal (&self->priv->num, &y->priv->num);
	return result;
}


gint
number_compare (Number* self,
                Number* y)
{
	gint result = 0;
	MPFRRealRef* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (y != NULL, 0);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = mpc_realref (&y->priv->num);
	result = mpfr_cmp (&_tmp0_->val, &_tmp1_->val);
	return result;
}


Number*
number_sgn (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	MPFRRealRef* _tmp0_;
	Number* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = mpc_realref (&self->priv->num);
	_tmp1_ = number_new_integer ((gint64) mpfr_sgn (&_tmp0_->val), (gint64) 0);
	z = _tmp1_;
	result = z;
	return result;
}


Number*
number_invert_sign (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_neg (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_abs (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	mpc_abs (&_tmp2_->val, &self->priv->num, MPFR_RNDN);
	result = z;
	return result;
}


Number*
number_arg (Number* self,
            AngleUnit unit)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	MPFRRealRef* _tmp5_;
	Number* _tmp6_;
	MPFRRealRef* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Argument not defined for zero"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_new ();
	z = _tmp3_;
	_tmp4_ = z;
	_tmp5_ = mpc_imagref (&_tmp4_->priv->num);
	mpfr_set_zero (&_tmp5_->val, MPFR_RNDN);
	_tmp6_ = z;
	_tmp7_ = mpc_realref (&_tmp6_->priv->num);
	mpc_arg (&_tmp7_->val, &self->priv->num, MPFR_RNDN);
	_tmp8_ = z;
	_tmp9_ = z;
	number_mpc_from_radians (&_tmp8_->priv->num, &_tmp9_->priv->num, unit);
	if (!number_is_complex (self)) {
		_tmp10_ = number_is_negative (self);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		Number* _tmp11_;
		MPFRRealRef* _tmp12_;
		Number* _tmp13_;
		MPFRRealRef* _tmp14_;
		_tmp11_ = z;
		_tmp12_ = mpc_realref (&_tmp11_->priv->num);
		_tmp13_ = z;
		_tmp14_ = mpc_realref (&_tmp13_->priv->num);
		mpfr_abs (&_tmp12_->val, &_tmp14_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}


Number*
number_conjugate (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_conj (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_real_component (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_realref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_imaginary_component (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&self->priv->num);
	mpc_set_mpreal (&z->priv->num, &_tmp1_->val, NULL, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_integer_component (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_trunc (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number*
number_fractional_component (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_frac (&_tmp2_->val, &_tmp3_->val, MPFR_RNDN);
	result = z;
	return result;
}


Number*
number_fractional_part (Number* self)
{
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_floor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_subtract (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


Number*
number_floor (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_floor (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number*
number_ceiling (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_ceil (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number*
number_round (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	MPFRRealRef* _tmp2_;
	MPFRRealRef* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = mpc_imagref (&z->priv->num);
	mpfr_set_zero (&_tmp1_->val, MPFR_RNDN);
	_tmp2_ = mpc_realref (&z->priv->num);
	_tmp3_ = mpc_realref (&self->priv->num);
	mpfr_round (&_tmp2_->val, &_tmp3_->val);
	result = z;
	return result;
}


Number*
number_reciprocal (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	MPFRRealRef* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set_si_si (&z->priv->num, (glong) 1, (glong) 0, MPC_RNDNN);
	_tmp1_ = mpc_realref (&z->priv->num);
	mpc_fr_div (&z->priv->num, &_tmp1_->val, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_epowy (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_exp (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_xpowy (Number* self,
              Number* y)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	Number* z = NULL;
	Number* _tmp14_;
	Number* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (self)) {
		_tmp0_ = number_is_negative (y);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	if (number_is_zero (self)) {
		_tmp4_ = number_is_zero (y);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		Number* _tmp7_;
		_tmp5_ = number_get_error ();
		_tmp6_ = _tmp5_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp7_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp7_;
		return result;
	}
	if (!number_is_complex (self)) {
		_tmp9_ = !number_is_complex (y);
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = !number_is_integer (y);
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Number* reciprocal = NULL;
		Number* _tmp10_;
		Number* _tmp11_;
		_tmp10_ = number_reciprocal (y);
		reciprocal = _tmp10_;
		_tmp11_ = reciprocal;
		if (number_is_integer (_tmp11_)) {
			Number* _tmp12_;
			Number* _tmp13_;
			_tmp12_ = reciprocal;
			_tmp13_ = number_root (self, number_to_integer (_tmp12_));
			result = _tmp13_;
			_g_object_unref0 (reciprocal);
			return result;
		}
		_g_object_unref0 (reciprocal);
	}
	_tmp14_ = number_new ();
	z = _tmp14_;
	_tmp15_ = z;
	mpc_pow (&_tmp15_->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_xpowy_integer (Number* self,
                      gint64 n)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp4_ = FALSE;
	Number* z = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		_tmp0_ = n < ((gint64) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("The power of zero is undefined for a negative exponent"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	if (number_is_zero (self)) {
		_tmp4_ = n == ((gint64) 0);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		Number* _tmp7_;
		_tmp5_ = number_get_error ();
		_tmp6_ = _tmp5_;
		number_set_error (_ ("Zero raised to zero is undefined"));
		_tmp7_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp7_;
		return result;
	}
	_tmp8_ = number_new ();
	z = _tmp8_;
	_tmp9_ = z;
	mpc_pow_si (&_tmp9_->priv->num, &self->priv->num, (glong) n, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_root (Number* self,
             gint64 n)
{
	Number* result = NULL;
	guint64 p = 0ULL;
	Number* z = NULL;
	Number* _tmp0_;
	gboolean _tmp6_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (n < ((gint64) 0)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_ui_div (&_tmp1_->priv->num, (gulong) 1, &self->priv->num, MPC_RNDNN);
		if (n == G_MININT64) {
			p = ((guint64) G_MAXINT64) + 1;
		} else {
			p = (guint64) (-n);
		}
	} else {
		if (n > ((gint64) 0)) {
			Number* _tmp2_;
			_tmp2_ = z;
			mpc_set (&_tmp2_->priv->num, &self->priv->num, MPC_RNDNN);
			p = (guint64) n;
		} else {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			Number* _tmp5_;
			_tmp3_ = number_get_error ();
			_tmp4_ = _tmp3_;
			number_set_error (_ ("The zeroth root of a number is undefined"));
			_tmp5_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp5_;
			_g_object_unref0 (z);
			return result;
		}
	}
	if (!number_is_complex (self)) {
		gboolean _tmp7_ = FALSE;
		if (!number_is_negative (self)) {
			_tmp7_ = TRUE;
		} else {
			guint64 _tmp8_;
			_tmp8_ = p;
			_tmp7_ = (_tmp8_ & 1) == ((guint64) 1);
		}
		_tmp6_ = _tmp7_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		Number* _tmp9_;
		MPFRRealRef* _tmp10_;
		Number* _tmp11_;
		MPFRRealRef* _tmp12_;
		guint64 _tmp13_;
		Number* _tmp14_;
		MPFRRealRef* _tmp15_;
		_tmp9_ = z;
		_tmp10_ = mpc_realref (&_tmp9_->priv->num);
		_tmp11_ = z;
		_tmp12_ = mpc_realref (&_tmp11_->priv->num);
		_tmp13_ = p;
		mpfr_root (&_tmp10_->val, &_tmp12_->val, (gulong) _tmp13_, MPFR_RNDN);
		_tmp14_ = z;
		_tmp15_ = mpc_imagref (&_tmp14_->priv->num);
		mpfr_set_zero (&_tmp15_->val, MPFR_RNDN);
	} else {
		__mpfr_struct tmp = {0};
		mpfr_prec_t _tmp16_;
		mpfr_prec_t _tmp17_;
		guint64 _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		_tmp16_ = number_get_precision ();
		_tmp17_ = _tmp16_;
		mpfr_init2 (&tmp, _tmp17_);
		_tmp18_ = p;
		mpfr_set_ui (&tmp, (gulong) _tmp18_, MPFR_RNDN);
		mpfr_ui_div (&tmp, (gulong) 1, &tmp, MPFR_RNDN);
		_tmp19_ = z;
		_tmp20_ = z;
		mpc_pow_fr (&_tmp19_->priv->num, &_tmp20_->priv->num, &tmp, MPC_RNDNN);
		mpfr_clear (&tmp);
	}
	result = z;
	return result;
}


Number*
number_sqrt (Number* self)
{
	Number* result = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_root (self, (gint64) 2);
	result = _tmp0_;
	return result;
}


Number*
number_ln (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	gboolean _tmp5_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_new ();
	z = _tmp3_;
	_tmp4_ = z;
	mpc_log (&_tmp4_->priv->num, &self->priv->num, MPC_RNDNN);
	if (!number_is_complex (self)) {
		_tmp5_ = number_is_negative (self);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		Number* _tmp6_;
		MPFRRealRef* _tmp7_;
		Number* _tmp8_;
		MPFRRealRef* _tmp9_;
		_tmp6_ = z;
		_tmp7_ = mpc_imagref (&_tmp6_->priv->num);
		_tmp8_ = z;
		_tmp9_ = mpc_imagref (&_tmp8_->priv->num);
		mpfr_abs (&_tmp7_->val, &_tmp9_->val, MPFR_RNDN);
	}
	result = z;
	return result;
}


Number*
number_logarithm (Number* self,
                  gint64 n)
{
	Number* result = NULL;
	Number* t1 = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Logarithm of zero is undefined"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_new_integer (n, (gint64) 0);
	t1 = _tmp3_;
	_tmp4_ = number_ln (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = t1;
	_tmp7_ = number_ln (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = number_divide (_tmp5_, _tmp8_);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (_tmp8_);
	_g_object_unref0 (_tmp5_);
	result = _tmp10_;
	_g_object_unref0 (t1);
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


Number*
number_factorial (Number* self)
{
	Number* result = NULL;
	gint64 value = 0LL;
	Number* z = NULL;
	Number* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	if (number_is_zero (self)) {
		Number* _tmp0_;
		_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
		result = _tmp0_;
		return result;
	}
	if (!number_is_natural (self)) {
		gboolean _tmp1_ = FALSE;
		Number* tmp = NULL;
		Number* _tmp5_;
		Number* _tmp6_;
		Number* _tmp7_;
		Number* _tmp8_;
		__mpfr_struct tmp2 = {0};
		mpfr_prec_t _tmp9_;
		mpfr_prec_t _tmp10_;
		Number* _tmp11_;
		MPFRRealRef* _tmp12_;
		Number* _tmp13_;
		if (number_is_negative (self)) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = number_is_complex (self);
		}
		if (_tmp1_) {
			const gchar* _tmp2_;
			const gchar* _tmp3_;
			Number* _tmp4_;
			_tmp2_ = number_get_error ();
			_tmp3_ = _tmp2_;
			number_set_error (_ ("Factorial is only defined for non-negative real numbers"));
			_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
			result = _tmp4_;
			return result;
		}
		_tmp5_ = number_new_integer ((gint64) 1, (gint64) 0);
		_tmp6_ = _tmp5_;
		_tmp7_ = number_add (self, _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		tmp = _tmp8_;
		_tmp9_ = number_get_precision ();
		_tmp10_ = _tmp9_;
		mpfr_init2 (&tmp2, _tmp10_);
		_tmp11_ = tmp;
		_tmp12_ = mpc_realref (&_tmp11_->priv->num);
		mpfr_gamma (&tmp2, &_tmp12_->val, MPFR_RNDN);
		_tmp13_ = number_new_mpreal (&tmp2, NULL);
		result = _tmp13_;
		mpfr_clear (&tmp2);
		_g_object_unref0 (tmp);
		return result;
	}
	value = number_to_integer (self);
	_tmp14_ = _g_object_ref0 (self);
	z = _tmp14_;
	{
		gint i = 0;
		i = 2;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				gint64 _tmp18_;
				Number* _tmp19_;
				gint _tmp20_;
				Number* _tmp21_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = value;
				if (!(((gint64) _tmp17_) < _tmp18_)) {
					break;
				}
				_tmp19_ = z;
				_tmp20_ = i;
				_tmp21_ = number_multiply_integer (_tmp19_, (gint64) _tmp20_);
				_g_object_unref0 (z);
				z = _tmp21_;
			}
		}
	}
	result = z;
	return result;
}


Number*
number_add (Number* self,
            Number* y)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_add (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_subtract (Number* self,
                 Number* y)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sub (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_multiply (Number* self,
                 Number* y)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_mul (&z->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_multiply_integer (Number* self,
                         gint64 y)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_mul_si (&z->priv->num, &self->priv->num, (glong) y, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_divide (Number* self,
               Number* y)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp3_;
	Number* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (number_is_zero (y)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Division by zero is undefined"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = number_new ();
	z = _tmp3_;
	_tmp4_ = z;
	mpc_div (&_tmp4_->priv->num, &self->priv->num, &y->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_divide_integer (Number* self,
                       gint64 y)
{
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer (y, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_divide (self, _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	result = _tmp3_;
	return result;
}


Number*
number_modulus_divide (Number* self,
                       Number* y)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* t1 = NULL;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* t2 = NULL;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* z = NULL;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	Number* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_integer (y);
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		Number* _tmp3_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Modulus division is only defined for integers"));
		_tmp3_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp3_;
		return result;
	}
	_tmp4_ = number_divide (self, y);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_floor (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	t1 = _tmp7_;
	_tmp8_ = t1;
	_tmp9_ = number_multiply (_tmp8_, y);
	t2 = _tmp9_;
	_tmp10_ = t2;
	_tmp11_ = number_subtract (self, _tmp10_);
	z = _tmp11_;
	_tmp12_ = number_new_integer ((gint64) 0, (gint64) 0);
	_g_object_unref0 (t1);
	t1 = _tmp12_;
	_tmp15_ = t1;
	if (number_compare (y, _tmp15_) < 0) {
		Number* _tmp16_;
		Number* _tmp17_;
		_tmp16_ = z;
		_tmp17_ = t1;
		_tmp14_ = number_compare (_tmp16_, _tmp17_) > 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		_tmp13_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		Number* _tmp19_;
		_tmp19_ = t1;
		if (number_compare (y, _tmp19_) > 0) {
			Number* _tmp20_;
			Number* _tmp21_;
			_tmp20_ = z;
			_tmp21_ = t1;
			_tmp18_ = number_compare (_tmp20_, _tmp21_) < 0;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp13_ = _tmp18_;
	}
	if (_tmp13_) {
		Number* _tmp22_;
		Number* _tmp23_;
		_tmp22_ = z;
		_tmp23_ = number_add (_tmp22_, y);
		_g_object_unref0 (z);
		z = _tmp23_;
	}
	result = z;
	_g_object_unref0 (t2);
	_g_object_unref0 (t1);
	return result;
}


Number*
number_modular_exponentiation (Number* self,
                               Number* exp,
                               Number* mod)
{
	Number* result = NULL;
	Number* base_value = NULL;
	Number* _tmp0_;
	Number* exp_value = NULL;
	Number* _tmp3_;
	Number* ans = NULL;
	Number* _tmp4_;
	Number* two = NULL;
	Number* _tmp5_;
	Number* _tmp27_;
	Number* _tmp28_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (exp != NULL, NULL);
	g_return_val_if_fail (mod != NULL, NULL);
	_tmp0_ = number_copy (self);
	base_value = _tmp0_;
	if (number_is_negative (exp)) {
		Number* _tmp1_;
		Number* _tmp2_;
		_tmp1_ = base_value;
		_tmp2_ = number_reciprocal (_tmp1_);
		_g_object_unref0 (base_value);
		base_value = _tmp2_;
	}
	_tmp3_ = number_abs (exp);
	exp_value = _tmp3_;
	_tmp4_ = number_new_integer ((gint64) 1, (gint64) 0);
	ans = _tmp4_;
	_tmp5_ = number_new_integer ((gint64) 2, (gint64) 0);
	two = _tmp5_;
	while (TRUE) {
		Number* _tmp6_;
		gboolean is_even = FALSE;
		Number* _tmp7_;
		Number* _tmp8_;
		Number* _tmp9_;
		Number* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		Number* _tmp18_;
		Number* _tmp19_;
		Number* _tmp20_;
		Number* _tmp21_;
		Number* _tmp22_;
		Number* _tmp23_;
		Number* _tmp24_;
		Number* _tmp25_;
		Number* _tmp26_;
		_tmp6_ = exp_value;
		if (!(!number_is_zero (_tmp6_))) {
			break;
		}
		_tmp7_ = exp_value;
		_tmp8_ = two;
		_tmp9_ = number_modulus_divide (_tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = number_is_zero (_tmp10_);
		_g_object_unref0 (_tmp10_);
		is_even = _tmp11_;
		_tmp12_ = is_even;
		if (!_tmp12_) {
			Number* _tmp13_;
			Number* _tmp14_;
			Number* _tmp15_;
			Number* _tmp16_;
			Number* _tmp17_;
			_tmp13_ = ans;
			_tmp14_ = base_value;
			_tmp15_ = number_multiply (_tmp13_, _tmp14_);
			_g_object_unref0 (ans);
			ans = _tmp15_;
			_tmp16_ = ans;
			_tmp17_ = number_modulus_divide (_tmp16_, mod);
			_g_object_unref0 (ans);
			ans = _tmp17_;
		}
		_tmp18_ = base_value;
		_tmp19_ = base_value;
		_tmp20_ = number_multiply (_tmp18_, _tmp19_);
		_g_object_unref0 (base_value);
		base_value = _tmp20_;
		_tmp21_ = base_value;
		_tmp22_ = number_modulus_divide (_tmp21_, mod);
		_g_object_unref0 (base_value);
		base_value = _tmp22_;
		_tmp23_ = exp_value;
		_tmp24_ = number_divide_integer (_tmp23_, (gint64) 2);
		_tmp25_ = _tmp24_;
		_tmp26_ = number_floor (_tmp25_);
		_g_object_unref0 (exp_value);
		exp_value = _tmp26_;
		_g_object_unref0 (_tmp25_);
	}
	_tmp27_ = ans;
	_tmp28_ = number_modulus_divide (_tmp27_, mod);
	result = _tmp28_;
	_g_object_unref0 (two);
	_g_object_unref0 (ans);
	_g_object_unref0 (exp_value);
	_g_object_unref0 (base_value);
	return result;
}


Number*
number_sin (Number* self,
            AngleUnit unit)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp3_;
	Number* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (number_is_complex (self)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_set (&_tmp1_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp2_;
		_tmp2_ = z;
		number_mpc_to_radians (&_tmp2_->priv->num, &self->priv->num, unit);
	}
	_tmp3_ = z;
	_tmp4_ = z;
	mpc_sin (&_tmp3_->priv->num, &_tmp4_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_cos (Number* self,
            AngleUnit unit)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp3_;
	Number* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	if (number_is_complex (self)) {
		Number* _tmp1_;
		_tmp1_ = z;
		mpc_set (&_tmp1_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp2_;
		_tmp2_ = z;
		number_mpc_to_radians (&_tmp2_->priv->num, &self->priv->num, unit);
	}
	_tmp3_ = z;
	_tmp4_ = z;
	mpc_cos (&_tmp3_->priv->num, &_tmp4_->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_tan (Number* self,
            AngleUnit unit)
{
	Number* result = NULL;
	Number* x_radians = NULL;
	Number* _tmp0_;
	Number* check = NULL;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	Number* _tmp7_;
	Number* _tmp8_;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	Number* _tmp12_;
	Number* z = NULL;
	Number* _tmp16_;
	Number* _tmp19_;
	Number* _tmp20_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_to_radians (self, unit);
	x_radians = _tmp0_;
	_tmp1_ = x_radians;
	_tmp2_ = number_new_pi ();
	_tmp3_ = _tmp2_;
	_tmp4_ = number_divide_integer (_tmp3_, (gint64) 2);
	_tmp5_ = _tmp4_;
	_tmp6_ = number_subtract (_tmp1_, _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = number_new_pi ();
	_tmp9_ = _tmp8_;
	_tmp10_ = number_divide (_tmp7_, _tmp9_);
	_tmp11_ = _tmp10_;
	_g_object_unref0 (_tmp9_);
	_g_object_unref0 (_tmp7_);
	_g_object_unref0 (_tmp5_);
	_g_object_unref0 (_tmp3_);
	check = _tmp11_;
	_tmp12_ = check;
	if (number_is_integer (_tmp12_)) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		Number* _tmp15_;
		_tmp13_ = number_get_error ();
		_tmp14_ = _tmp13_;
		number_set_error (_ ("Tangent is undefined for angles that are multiples of π (180°) from π∕" \
"2 (90°)"));
		_tmp15_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp15_;
		_g_object_unref0 (check);
		_g_object_unref0 (x_radians);
		return result;
	}
	_tmp16_ = number_new ();
	z = _tmp16_;
	if (number_is_complex (self)) {
		Number* _tmp17_;
		_tmp17_ = z;
		mpc_set (&_tmp17_->priv->num, &self->priv->num, MPC_RNDNN);
	} else {
		Number* _tmp18_;
		_tmp18_ = z;
		number_mpc_to_radians (&_tmp18_->priv->num, &self->priv->num, unit);
	}
	_tmp19_ = z;
	_tmp20_ = z;
	mpc_tan (&_tmp19_->priv->num, &_tmp20_->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (check);
	_g_object_unref0 (x_radians);
	return result;
}


Number*
number_asin (Number* self,
             AngleUnit unit)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_) > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_compare (self, _tmp5_) < 0;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		Number* _tmp8_;
		_tmp6_ = number_get_error ();
		_tmp7_ = _tmp6_;
		number_set_error (_ ("Inverse sine is undefined for values outside [-1, 1]"));
		_tmp8_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp8_;
		return result;
	}
	_tmp9_ = number_new ();
	z = _tmp9_;
	_tmp10_ = z;
	mpc_asin (&_tmp10_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp11_ = z;
	if (!number_is_complex (_tmp11_)) {
		Number* _tmp12_;
		Number* _tmp13_;
		_tmp12_ = z;
		_tmp13_ = z;
		number_mpc_from_radians (&_tmp12_->priv->num, &_tmp13_->priv->num, unit);
	}
	result = z;
	return result;
}


Number*
number_acos (Number* self,
             AngleUnit unit)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	Number* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_) > 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_compare (self, _tmp5_) < 0;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		Number* _tmp8_;
		_tmp6_ = number_get_error ();
		_tmp7_ = _tmp6_;
		number_set_error (_ ("Inverse cosine is undefined for values outside [-1, 1]"));
		_tmp8_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp8_;
		return result;
	}
	_tmp9_ = number_new ();
	z = _tmp9_;
	_tmp10_ = z;
	mpc_acos (&_tmp10_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp11_ = z;
	if (!number_is_complex (_tmp11_)) {
		Number* _tmp12_;
		Number* _tmp13_;
		_tmp12_ = z;
		_tmp13_ = z;
		number_mpc_from_radians (&_tmp12_->priv->num, &_tmp13_->priv->num, unit);
	}
	result = z;
	return result;
}


Number*
number_atan (Number* self,
             AngleUnit unit)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	_tmp1_ = z;
	mpc_atan (&_tmp1_->priv->num, &self->priv->num, MPC_RNDNN);
	_tmp2_ = z;
	if (!number_is_complex (_tmp2_)) {
		Number* _tmp3_;
		Number* _tmp4_;
		_tmp3_ = z;
		_tmp4_ = z;
		number_mpc_from_radians (&_tmp3_->priv->num, &_tmp4_->priv->num, unit);
	}
	result = z;
	return result;
}


Number*
number_sinh (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_sinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_cosh (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_cosh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_tanh (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_tanh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_asinh (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_asinh (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


Number*
number_acosh (Number* self)
{
	Number* result = NULL;
	Number* t = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* z = NULL;
	Number* _tmp5_;
	Number* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 1, (gint64) 0);
	t = _tmp0_;
	_tmp1_ = t;
	if (number_compare (self, _tmp1_) < 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		Number* _tmp4_;
		_tmp2_ = number_get_error ();
		_tmp3_ = _tmp2_;
		number_set_error (_ ("Inverse hyperbolic cosine is undefined for values less than one"));
		_tmp4_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp4_;
		_g_object_unref0 (t);
		return result;
	}
	_tmp5_ = number_new ();
	z = _tmp5_;
	_tmp6_ = z;
	mpc_acosh (&_tmp6_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	_g_object_unref0 (t);
	return result;
}


Number*
number_atanh (Number* self)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp1_;
	Number* _tmp2_;
	gboolean _tmp3_;
	Number* z = NULL;
	Number* _tmp9_;
	Number* _tmp10_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp2_ = _tmp1_;
	_tmp3_ = number_compare (self, _tmp2_) >= 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp3_) {
		_tmp0_ = TRUE;
	} else {
		Number* _tmp4_;
		Number* _tmp5_;
		_tmp4_ = number_new_integer ((gint64) -1, (gint64) 0);
		_tmp5_ = _tmp4_;
		_tmp0_ = number_compare (self, _tmp5_) <= 0;
		_g_object_unref0 (_tmp5_);
	}
	if (_tmp0_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		Number* _tmp8_;
		_tmp6_ = number_get_error ();
		_tmp7_ = _tmp6_;
		number_set_error (_ ("Inverse hyperbolic tangent is undefined for values outside [-1, 1]"));
		_tmp8_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp8_;
		return result;
	}
	_tmp9_ = number_new ();
	z = _tmp9_;
	_tmp10_ = z;
	mpc_atanh (&_tmp10_->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


static gint
__lambda4_ (Number* self,
            gint v1,
            gint v2)
{
	gint result = 0;
	result = v1 & v2;
	return result;
}


static gint
___lambda4__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda4_ ((Number*) self, v1, v2);
	return result;
}


Number*
number_and (Number* self,
            Number* y)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_positive_integer (y);
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Boolean AND is only defined for positive integers"));
	}
	_tmp3_ = number_bitwise (self, y, ___lambda4__bitwise_func, self, 0);
	result = _tmp3_;
	return result;
}


static gint
__lambda5_ (Number* self,
            gint v1,
            gint v2)
{
	gint result = 0;
	result = v1 | v2;
	return result;
}


static gint
___lambda5__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda5_ ((Number*) self, v1, v2);
	return result;
}


Number*
number_or (Number* self,
           Number* y)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_positive_integer (y);
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Boolean OR is only defined for positive integers"));
	}
	_tmp3_ = number_bitwise (self, y, ___lambda5__bitwise_func, self, 0);
	result = _tmp3_;
	return result;
}


static gint
__lambda6_ (Number* self,
            gint v1,
            gint v2)
{
	gint result = 0;
	result = v1 ^ v2;
	return result;
}


static gint
___lambda6__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda6_ ((Number*) self, v1, v2);
	return result;
}


Number*
number_xor (Number* self,
            Number* y)
{
	Number* result = NULL;
	gboolean _tmp0_ = FALSE;
	Number* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = !number_is_positive_integer (y);
	}
	if (_tmp0_) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = number_get_error ();
		_tmp2_ = _tmp1_;
		number_set_error (_ ("Boolean XOR is only defined for positive integers"));
	}
	_tmp3_ = number_bitwise (self, y, ___lambda6__bitwise_func, self, 0);
	result = _tmp3_;
	return result;
}


static gint
__lambda7_ (Number* self,
            gint v1,
            gint v2)
{
	gint result = 0;
	result = v1 ^ 0xF;
	return result;
}


static gint
___lambda7__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda7_ ((Number*) self, v1, v2);
	return result;
}


Number*
number_not (Number* self,
            gint wordlen)
{
	Number* result = NULL;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_positive_integer (self)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Boolean NOT is only defined for positive integers"));
	}
	_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_bitwise (self, _tmp3_, ___lambda7__bitwise_func, self, wordlen);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


Number*
number_mask (Number* self,
             Number* x,
             gint wordlen)
{
	Number* result = NULL;
	gchar* text = NULL;
	gchar* _tmp0_;
	gint len = 0;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint offset = 0;
	gint _tmp4_ = 0;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = number_to_hex_string (x);
	text = _tmp0_;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	len = _tmp3_;
	offset = wordlen / 4;
	_tmp5_ = len;
	_tmp6_ = offset;
	if (_tmp5_ > _tmp6_) {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = len;
		_tmp8_ = offset;
		_tmp4_ = ((gint) _tmp7_) - _tmp8_;
	} else {
		_tmp4_ = 0;
	}
	offset = _tmp4_;
	_tmp9_ = text;
	_tmp10_ = offset;
	_tmp11_ = string_substring (_tmp9_, (glong) _tmp10_, (glong) -1);
	_tmp12_ = _tmp11_;
	_tmp13_ = mp_set_from_string (_tmp12_, 16);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	result = _tmp14_;
	_g_free0 (text);
	return result;
}


Number*
number_shift (Number* self,
              gint count)
{
	Number* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	if (!number_is_integer (self)) {
		const gchar* _tmp0_;
		const gchar* _tmp1_;
		Number* _tmp2_;
		_tmp0_ = number_get_error ();
		_tmp1_ = _tmp0_;
		number_set_error (_ ("Shift is only possible on integer values"));
		_tmp2_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp2_;
		return result;
	}
	if (count >= 0) {
		gint multiplier = 0;
		gint _tmp7_;
		Number* _tmp8_;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_;
					gint _tmp6_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					if (!(_tmp5_ < count)) {
						break;
					}
					_tmp6_ = multiplier;
					multiplier = _tmp6_ * 2;
				}
			}
		}
		_tmp7_ = multiplier;
		_tmp8_ = number_multiply_integer (self, (gint64) _tmp7_);
		result = _tmp8_;
		return result;
	} else {
		gint multiplier = 0;
		gint _tmp13_;
		Number* _tmp14_;
		Number* _tmp15_;
		Number* _tmp16_;
		Number* _tmp17_;
		multiplier = 1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp9_ = FALSE;
				_tmp9_ = TRUE;
				while (TRUE) {
					gint _tmp11_;
					gint _tmp12_;
					if (!_tmp9_) {
						gint _tmp10_;
						_tmp10_ = i;
						i = _tmp10_ + 1;
					}
					_tmp9_ = FALSE;
					_tmp11_ = i;
					if (!(_tmp11_ < (-count))) {
						break;
					}
					_tmp12_ = multiplier;
					multiplier = _tmp12_ * 2;
				}
			}
		}
		_tmp13_ = multiplier;
		_tmp14_ = number_divide_integer (self, (gint64) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = number_floor (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		result = _tmp17_;
		return result;
	}
}


static gint
__lambda8_ (Number* self,
            gint v1,
            gint v2)
{
	gint result = 0;
	result = v1 ^ v2;
	return result;
}


static gint
___lambda8__bitwise_func (gint v1,
                          gint v2,
                          gpointer self)
{
	gint result;
	result = __lambda8_ ((Number*) self, v1, v2);
	return result;
}


Number*
number_ones_complement (Number* self,
                        gint wordlen)
{
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new_integer ((gint64) 0, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_bitwise (self, _tmp1_, ___lambda8__bitwise_func, self, wordlen);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_not (_tmp3_, wordlen);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


Number*
number_twos_complement (Number* self,
                        gint wordlen)
{
	Number* result = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_ones_complement (self, wordlen);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp3_ = _tmp2_;
	_tmp4_ = number_add (_tmp1_, _tmp3_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	result = _tmp5_;
	return result;
}


static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}


GList*
number_factorize (Number* self)
{
	GList* result = NULL;
	GList* factors = NULL;
	Number* value = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	gboolean _tmp7_;
	guint64 num = 0ULL;
	guint64 _tmp9_;
	guint64 _tmp10_;
	guint64 _tmp11_;
	Number* int_max = NULL;
	guint64 _tmp12_;
	Number* _tmp13_;
	Number* _tmp14_;
	Number* _tmp15_;
	Number* divisor = NULL;
	Number* _tmp22_;
	Number* _tmp31_;
	Number* root = NULL;
	Number* _tmp32_;
	Number* _tmp33_;
	Number* _tmp52_;
	Number* _tmp53_;
	Number* _tmp54_;
	gboolean _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	_tmp0_ = number_abs (self);
	value = _tmp0_;
	_tmp1_ = value;
	if (number_is_zero (_tmp1_)) {
		Number* _tmp2_;
		Number* _tmp3_;
		_tmp2_ = value;
		_tmp3_ = _g_object_ref0 (_tmp2_);
		factors = g_list_append (factors, _tmp3_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	_tmp4_ = value;
	_tmp5_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp6_ = _tmp5_;
	_tmp7_ = number_equals (_tmp4_, _tmp6_);
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		Number* _tmp8_;
		_tmp8_ = _g_object_ref0 (self);
		factors = g_list_append (factors, _tmp8_);
		result = factors;
		_g_object_unref0 (value);
		return result;
	}
	num = (guint64) 1;
	_tmp9_ = num;
	num = _tmp9_ << 63;
	_tmp10_ = num;
	_tmp11_ = num;
	num = _tmp10_ + (_tmp11_ - 1);
	_tmp12_ = num;
	_tmp13_ = number_new_unsigned_integer (_tmp12_, (guint64) 0);
	int_max = _tmp13_;
	_tmp14_ = value;
	_tmp15_ = int_max;
	if (number_compare (_tmp14_, _tmp15_) <= 0) {
		GList* factors_int64 = NULL;
		Number* _tmp16_;
		GList* _tmp17_;
		_tmp16_ = value;
		_tmp17_ = number_factorize_uint64 (self, number_to_unsigned_integer (_tmp16_));
		factors_int64 = _tmp17_;
		if (number_is_negative (self)) {
			GList* _tmp18_;
			GList* _tmp19_;
			gconstpointer _tmp20_;
			Number* _tmp21_;
			_tmp18_ = factors_int64;
			_tmp19_ = factors_int64;
			_tmp20_ = _tmp19_->data;
			_tmp21_ = number_invert_sign ((Number*) _tmp20_);
			_g_object_unref0 (_tmp18_->data);
			_tmp18_->data = _tmp21_;
		}
		result = factors_int64;
		_g_object_unref0 (int_max);
		_g_object_unref0 (value);
		__g_list_free__g_object_unref0_0 (factors);
		return result;
	}
	_tmp22_ = number_new_integer ((gint64) 2, (gint64) 0);
	divisor = _tmp22_;
	while (TRUE) {
		Number* tmp = NULL;
		Number* _tmp23_;
		Number* _tmp24_;
		Number* _tmp25_;
		Number* _tmp26_;
		_tmp23_ = value;
		_tmp24_ = divisor;
		_tmp25_ = number_divide (_tmp23_, _tmp24_);
		tmp = _tmp25_;
		_tmp26_ = tmp;
		if (number_is_integer (_tmp26_)) {
			Number* _tmp27_;
			Number* _tmp28_;
			Number* _tmp29_;
			Number* _tmp30_;
			_tmp27_ = tmp;
			_tmp28_ = _g_object_ref0 (_tmp27_);
			_g_object_unref0 (value);
			value = _tmp28_;
			_tmp29_ = divisor;
			_tmp30_ = _g_object_ref0 (_tmp29_);
			factors = g_list_append (factors, _tmp30_);
		} else {
			_g_object_unref0 (tmp);
			break;
		}
		_g_object_unref0 (tmp);
	}
	_tmp31_ = number_new_integer ((gint64) 3, (gint64) 0);
	_g_object_unref0 (divisor);
	divisor = _tmp31_;
	_tmp32_ = value;
	_tmp33_ = number_sqrt (_tmp32_);
	root = _tmp33_;
	while (TRUE) {
		Number* _tmp34_;
		Number* _tmp35_;
		Number* tmp = NULL;
		Number* _tmp36_;
		Number* _tmp37_;
		Number* _tmp38_;
		Number* _tmp39_;
		_tmp34_ = divisor;
		_tmp35_ = root;
		if (!(number_compare (_tmp34_, _tmp35_) <= 0)) {
			break;
		}
		_tmp36_ = value;
		_tmp37_ = divisor;
		_tmp38_ = number_divide (_tmp36_, _tmp37_);
		tmp = _tmp38_;
		_tmp39_ = tmp;
		if (number_is_integer (_tmp39_)) {
			Number* _tmp40_;
			Number* _tmp41_;
			Number* _tmp42_;
			Number* _tmp43_;
			Number* _tmp44_;
			Number* _tmp45_;
			_tmp40_ = tmp;
			_tmp41_ = _g_object_ref0 (_tmp40_);
			_g_object_unref0 (value);
			value = _tmp41_;
			_tmp42_ = value;
			_tmp43_ = number_sqrt (_tmp42_);
			_g_object_unref0 (root);
			root = _tmp43_;
			_tmp44_ = divisor;
			_tmp45_ = _g_object_ref0 (_tmp44_);
			factors = g_list_append (factors, _tmp45_);
		} else {
			Number* _tmp46_;
			Number* _tmp47_;
			Number* _tmp48_;
			Number* _tmp49_;
			Number* _tmp50_;
			Number* _tmp51_;
			_tmp46_ = divisor;
			_tmp47_ = number_new_integer ((gint64) 2, (gint64) 0);
			_tmp48_ = _tmp47_;
			_tmp49_ = number_add (_tmp46_, _tmp48_);
			_g_object_unref0 (tmp);
			tmp = _tmp49_;
			_g_object_unref0 (_tmp48_);
			_tmp50_ = tmp;
			_tmp51_ = _g_object_ref0 (_tmp50_);
			_g_object_unref0 (divisor);
			divisor = _tmp51_;
		}
		_g_object_unref0 (tmp);
	}
	_tmp52_ = value;
	_tmp53_ = number_new_integer ((gint64) 1, (gint64) 0);
	_tmp54_ = _tmp53_;
	_tmp55_ = number_compare (_tmp52_, _tmp54_) > 0;
	_g_object_unref0 (_tmp54_);
	if (_tmp55_) {
		Number* _tmp56_;
		Number* _tmp57_;
		_tmp56_ = value;
		_tmp57_ = _g_object_ref0 (_tmp56_);
		factors = g_list_append (factors, _tmp57_);
	}
	if (number_is_negative (self)) {
		GList* _tmp58_;
		GList* _tmp59_;
		gconstpointer _tmp60_;
		Number* _tmp61_;
		_tmp58_ = factors;
		_tmp59_ = factors;
		_tmp60_ = _tmp59_->data;
		_tmp61_ = number_invert_sign ((Number*) _tmp60_);
		_g_object_unref0 (_tmp58_->data);
		_tmp58_->data = _tmp61_;
	}
	result = factors;
	_g_object_unref0 (root);
	_g_object_unref0 (divisor);
	_g_object_unref0 (int_max);
	_g_object_unref0 (value);
	return result;
}


GList*
number_factorize_uint64 (Number* self,
                         guint64 n)
{
	GList* result = NULL;
	GList* factors = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	factors = NULL;
	while (TRUE) {
		Number* _tmp0_;
		if (!((n % 2) == ((guint64) 0))) {
			break;
		}
		n = n / 2;
		_tmp0_ = number_new_unsigned_integer ((guint64) 2, (guint64) 0);
		factors = g_list_append (factors, _tmp0_);
	}
	{
		guint64 divisor = 0ULL;
		divisor = (guint64) 3;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				guint64 _tmp3_;
				guint64 _tmp4_;
				if (!_tmp1_) {
					guint64 _tmp2_;
					_tmp2_ = divisor;
					divisor = _tmp2_ + 2;
				}
				_tmp1_ = FALSE;
				_tmp3_ = divisor;
				_tmp4_ = divisor;
				if (!(_tmp3_ <= (n / _tmp4_))) {
					break;
				}
				while (TRUE) {
					guint64 _tmp5_;
					guint64 _tmp6_;
					guint64 _tmp7_;
					Number* _tmp8_;
					_tmp5_ = divisor;
					if (!((n % _tmp5_) == ((guint64) 0))) {
						break;
					}
					_tmp6_ = divisor;
					n = n / _tmp6_;
					_tmp7_ = divisor;
					_tmp8_ = number_new_unsigned_integer (_tmp7_, (guint64) 0);
					factors = g_list_append (factors, _tmp8_);
				}
			}
		}
	}
	if (n > ((guint64) 1)) {
		Number* _tmp9_;
		_tmp9_ = number_new_unsigned_integer (n, (guint64) 0);
		factors = g_list_append (factors, _tmp9_);
	}
	result = factors;
	return result;
}


static Number*
number_copy (Number* self)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	mpc_set (&z->priv->num, &self->priv->num, MPC_RNDNN);
	result = z;
	return result;
}


static gboolean
_mpc_equal (const __mpc_struct * s1,
            const __mpc_struct * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return FALSE;
}


static void
number_mpc_from_radians (__mpc_struct* res,
                         __mpc_struct* op,
                         AngleUnit unit)
{
	gint i = 0;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp1_;
	mpfr_prec_t _tmp2_;
	gint _tmp3_;
	__mpc_struct _tmp4_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	switch (unit) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp0_;
				_tmp0_ = *op;
				mpc_set (res, &_tmp0_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&scale, _tmp2_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	_tmp3_ = i;
	mpfr_si_div (&scale, (glong) _tmp3_, &scale, MPFR_RNDN);
	_tmp4_ = *op;
	mpc_mul_fr (res, &_tmp4_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}


static void
number_mpc_to_radians (__mpc_struct* res,
                       __mpc_struct* op,
                       AngleUnit unit)
{
	gint i = 0;
	__mpfr_struct scale = {0};
	mpfr_prec_t _tmp1_;
	mpfr_prec_t _tmp2_;
	gint _tmp3_;
	__mpc_struct _tmp4_;
	g_return_if_fail (res != NULL);
	g_return_if_fail (op != NULL);
	switch (unit) {
		default:
		case ANGLE_UNIT_RADIANS:
		{
			if (_mpc_equal (res, op) != TRUE) {
				__mpc_struct _tmp0_;
				_tmp0_ = *op;
				mpc_set (res, &_tmp0_, MPC_RNDNN);
			}
			return;
		}
		case ANGLE_UNIT_DEGREES:
		{
			i = 180;
			break;
		}
		case ANGLE_UNIT_GRADIANS:
		{
			i = 200;
			break;
		}
	}
	_tmp1_ = number_get_precision ();
	_tmp2_ = _tmp1_;
	mpfr_init2 (&scale, _tmp2_);
	mpfr_const_pi (&scale, MPFR_RNDN);
	_tmp3_ = i;
	mpfr_div_si (&scale, &scale, (glong) _tmp3_, MPFR_RNDN);
	_tmp4_ = *op;
	mpc_mul_fr (res, &_tmp4_, &scale, MPC_RNDNN);
	mpfr_clear (&scale);
}


static Number*
number_to_radians (Number* self,
                   AngleUnit unit)
{
	Number* result = NULL;
	Number* z = NULL;
	Number* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = number_new ();
	z = _tmp0_;
	number_mpc_to_radians (&z->priv->num, &self->priv->num, unit);
	result = z;
	return result;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static Number*
number_bitwise (Number* self,
                Number* y,
                BitwiseFunc bitwise_operator,
                void* bitwise_operator_target,
                gint wordlen)
{
	Number* result = NULL;
	gchar* text1 = NULL;
	gchar* _tmp0_;
	gchar* text2 = NULL;
	gchar* _tmp1_;
	gint offset1 = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gint offset2 = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gint offset_out = 0;
	gint _tmp8_;
	gboolean _tmp14_ = FALSE;
	gint _tmp15_;
	gchar* text_out = NULL;
	gint _tmp24_;
	gchar* _tmp25_;
	gint text_out_length1;
	gint _text_out_size_;
	gchar* _tmp46_;
	gint _tmp46__length1;
	Number* _tmp47_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (y != NULL, NULL);
	_tmp0_ = number_to_hex_string (self);
	text1 = _tmp0_;
	_tmp1_ = number_to_hex_string (y);
	text2 = _tmp1_;
	_tmp2_ = text1;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	offset1 = _tmp4_ - 1;
	_tmp5_ = text2;
	_tmp6_ = strlen (_tmp5_);
	_tmp7_ = _tmp6_;
	offset2 = _tmp7_ - 1;
	offset_out = (wordlen / 4) - 1;
	_tmp8_ = offset_out;
	if (_tmp8_ <= 0) {
		gint _tmp9_ = 0;
		gint _tmp10_;
		gint _tmp11_;
		_tmp10_ = offset1;
		_tmp11_ = offset2;
		if (_tmp10_ > _tmp11_) {
			gint _tmp12_;
			_tmp12_ = offset1;
			_tmp9_ = _tmp12_;
		} else {
			gint _tmp13_;
			_tmp13_ = offset2;
			_tmp9_ = _tmp13_;
		}
		offset_out = _tmp9_;
	}
	_tmp15_ = offset_out;
	if (_tmp15_ > 0) {
		gboolean _tmp16_ = FALSE;
		gint _tmp17_;
		gint _tmp18_;
		_tmp17_ = offset_out;
		_tmp18_ = offset1;
		if (_tmp17_ < _tmp18_) {
			_tmp16_ = TRUE;
		} else {
			gint _tmp19_;
			gint _tmp20_;
			_tmp19_ = offset_out;
			_tmp20_ = offset2;
			_tmp16_ = _tmp19_ < _tmp20_;
		}
		_tmp14_ = _tmp16_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		Number* _tmp23_;
		_tmp21_ = number_get_error ();
		_tmp22_ = _tmp21_;
		number_set_error ("Overflow. Try a bigger word size");
		_tmp23_ = number_new_integer ((gint64) 0, (gint64) 0);
		result = _tmp23_;
		_g_free0 (text2);
		_g_free0 (text1);
		return result;
	}
	_tmp24_ = offset_out;
	_tmp25_ = g_new0 (gchar, _tmp24_ + 2);
	text_out = _tmp25_;
	text_out_length1 = _tmp24_ + 2;
	_text_out_size_ = text_out_length1;
	{
		gchar* _tmp26_;
		gint _tmp26__length1;
		gint _tmp27_;
		gchar _tmp28_;
		gboolean _tmp29_ = FALSE;
		_tmp26_ = text_out;
		_tmp26__length1 = text_out_length1;
		_tmp27_ = offset_out;
		_tmp26_[_tmp27_ + 1] = '\0';
		_tmp28_ = _tmp26_[_tmp27_ + 1];
		_tmp29_ = TRUE;
		while (TRUE) {
			gint _tmp31_;
			gint v1 = 0;
			gint v2 = 0;
			static const gchar digits[16] = {'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
			gint _tmp32_;
			gint _tmp36_;
			gchar* _tmp40_;
			gint _tmp40__length1;
			gint _tmp41_;
			gint _tmp42_;
			gint _tmp43_;
			gchar _tmp44_;
			gchar _tmp45_;
			if (!_tmp29_) {
				gint _tmp30_;
				_tmp30_ = offset_out;
				offset_out = _tmp30_ - 1;
			}
			_tmp29_ = FALSE;
			_tmp31_ = offset_out;
			if (!(_tmp31_ >= 0)) {
				break;
			}
			v1 = 0;
			v2 = 0;
			_tmp32_ = offset1;
			if (_tmp32_ >= 0) {
				const gchar* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp33_ = text1;
				_tmp34_ = offset1;
				v1 = number_hex_to_int (self, string_get (_tmp33_, (glong) _tmp34_));
				_tmp35_ = offset1;
				offset1 = _tmp35_ - 1;
			}
			_tmp36_ = offset2;
			if (_tmp36_ >= 0) {
				const gchar* _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				_tmp37_ = text2;
				_tmp38_ = offset2;
				v2 = number_hex_to_int (self, string_get (_tmp37_, (glong) _tmp38_));
				_tmp39_ = offset2;
				offset2 = _tmp39_ - 1;
			}
			_tmp40_ = text_out;
			_tmp40__length1 = text_out_length1;
			_tmp41_ = offset_out;
			_tmp42_ = v1;
			_tmp43_ = v2;
			_tmp44_ = digits[bitwise_operator (_tmp42_, _tmp43_, bitwise_operator_target)];
			_tmp40_[_tmp41_] = _tmp44_;
			_tmp45_ = _tmp40_[_tmp41_];
		}
	}
	_tmp46_ = text_out;
	_tmp46__length1 = text_out_length1;
	_tmp47_ = mp_set_from_string ((const gchar*) _tmp46_, 16);
	result = _tmp47_;
	text_out = (g_free (text_out), NULL);
	_g_free0 (text2);
	_g_free0 (text1);
	return result;
}


static gint
number_hex_to_int (Number* self,
                   gchar digit)
{
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	if (digit >= '0') {
		_tmp0_ = digit <= '9';
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = (gint) (digit - '0');
		return result;
	}
	if (digit >= 'A') {
		_tmp1_ = digit <= 'F';
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = (digit - 'A') + 10;
		return result;
	}
	if (digit >= 'a') {
		_tmp2_ = digit <= 'f';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = (digit - 'a') + 10;
		return result;
	}
	result = 0;
	return result;
}


static gchar*
number_to_hex_string (Number* self)
{
	gchar* result = NULL;
	Serializer* serializer = NULL;
	Serializer* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = serializer_new (DISPLAY_FORMAT_FIXED, 16, 0);
	serializer = _tmp0_;
	_tmp1_ = serializer_to_string (serializer, self);
	result = _tmp1_;
	_g_object_unref0 (serializer);
	return result;
}


Number*
number_construct (GType object_type)
{
	Number * self = NULL;
	self = (Number*) g_object_new (object_type, NULL);
	return self;
}


Number*
number_new (void)
{
	return number_construct (TYPE_NUMBER);
}


mpfr_prec_t
number_get_precision (void)
{
	mpfr_prec_t result;
	mpfr_prec_t _tmp0_;
	_tmp0_ = number__precision;
	result = _tmp0_;
	return result;
}


void
number_set_precision (mpfr_prec_t value)
{
	number__precision = value;
}


const gchar*
number_get_error (void)
{
	const gchar* result;
	const gchar* _tmp0_;
	_tmp0_ = number__error;
	result = _tmp0_;
	return result;
}


void
number_set_error (const gchar* value)
{
	gchar* _tmp0_;
	_tmp0_ = g_strdup (value);
	_g_free0 (number__error);
	number__error = _tmp0_;
}


static void
number_class_init (NumberClass * klass)
{
	number_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (NumberPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_number_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_number_set_property;
	G_OBJECT_CLASS (klass)->finalize = number_finalize;
}


static void
number_instance_init (Number * self)
{
	mpfr_prec_t _tmp0_;
	mpfr_prec_t _tmp1_;
	self->priv = NUMBER_GET_PRIVATE (self);
	_tmp0_ = number_get_precision ();
	_tmp1_ = _tmp0_;
	mpc_init2 (&self->priv->num, _tmp1_);
}


static void
number_finalize (GObject * obj)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER, Number);
	mpc_clear (&self->priv->num);
	G_OBJECT_CLASS (number_parent_class)->finalize (obj);
}


GType
number_get_type (void)
{
	static volatile gsize number_type_id__volatile = 0;
	if (g_once_init_enter (&number_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Number), 0, (GInstanceInitFunc) number_instance_init, NULL };
		GType number_type_id;
		number_type_id = g_type_register_static (G_TYPE_OBJECT, "Number", &g_define_type_info, 0);
		g_once_init_leave (&number_type_id__volatile, number_type_id);
	}
	return number_type_id__volatile;
}


static void
_vala_number_get_property (GObject * object,
                           guint property_id,
                           GValue * value,
                           GParamSpec * pspec)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_number_set_property (GObject * object,
                           guint property_id,
                           const GValue * value,
                           GParamSpec * pspec)
{
	Number * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NUMBER, Number);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gunichar _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	_tmp0_ = _vala_c;
	if (_tmp0_ != ((gunichar) 0)) {
		gchar* _tmp1_;
		_tmp1_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp1_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (0 < (*index)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


Number*
mp_set_from_string (const gchar* str,
                    gint default_base)
{
	Number* result = NULL;
	static const gunichar base_digits[10] = {8320U, 8321U, 8322U, 8323U, 8324U, 8325U, 8326U, 8327U, 8328U, 8329U};
	gint index = 0;
	gunichar c = 0U;
	gint end = 0;
	gint _tmp3_;
	gint number_base = 0;
	gint base_multiplier = 0;
	gint _tmp19_;
	gboolean negate = FALSE;
	gunichar _tmp20_ = 0U;
	gunichar _tmp21_;
	Number* z = NULL;
	Number* _tmp26_;
	static const gunichar fractions[15] = {189U, 8531U, 8532U, 188U, 190U, 8533U, 8534U, 8535U, 8536U, 8537U, 8538U, 8539U, 8540U, 8541U, 8542U};
	static const gint numerators[15] = {1, 1, 2, 1, 3, 1, 2, 3, 4, 1, 5, 1, 3, 5, 7};
	static const gint denominators[15] = {2, 3, 3, 4, 4, 5, 5, 5, 5, 6, 6, 8, 8, 8, 8};
	gboolean has_fraction = FALSE;
	gunichar _tmp43_ = 0U;
	gboolean _tmp44_;
	gboolean _tmp63_;
	gint _tmp89_;
	gint _tmp90_;
	gboolean _tmp91_;
	g_return_val_if_fail (str != NULL, NULL);
	if (string_index_of_char (str, 176U, 0) >= 0) {
		Number* _tmp0_;
		_tmp0_ = set_from_sexagesimal (str);
		result = _tmp0_;
		return result;
	}
	index = 0;
	while (TRUE) {
		gunichar _tmp1_ = 0U;
		gboolean _tmp2_;
		_tmp2_ = string_get_next_char (str, &index, &_tmp1_);
		c = _tmp1_;
		if (!_tmp2_) {
			break;
		}
	}
	_tmp3_ = index;
	end = _tmp3_;
	number_base = 0;
	base_multiplier = 1;
	while (TRUE) {
		gunichar _tmp4_ = 0U;
		gboolean _tmp5_;
		gint value = 0;
		gint _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp5_ = string_get_prev_char (str, &index, &_tmp4_);
		c = _tmp4_;
		if (!_tmp5_) {
			break;
		}
		value = -1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp6_ = FALSE;
				_tmp6_ = TRUE;
				while (TRUE) {
					gint _tmp8_;
					gunichar _tmp9_;
					gint _tmp10_;
					gunichar _tmp11_;
					if (!_tmp6_) {
						gint _tmp7_;
						_tmp7_ = i;
						i = _tmp7_ + 1;
					}
					_tmp6_ = FALSE;
					_tmp8_ = i;
					if (!(_tmp8_ < G_N_ELEMENTS (base_digits))) {
						break;
					}
					_tmp9_ = c;
					_tmp10_ = i;
					_tmp11_ = base_digits[_tmp10_];
					if (_tmp9_ == _tmp11_) {
						gint _tmp12_;
						_tmp12_ = i;
						value = _tmp12_;
						break;
					}
				}
			}
		}
		_tmp13_ = value;
		if (_tmp13_ < 0) {
			break;
		}
		_tmp14_ = index;
		end = _tmp14_;
		_tmp15_ = number_base;
		_tmp16_ = value;
		_tmp17_ = base_multiplier;
		number_base = _tmp15_ + (_tmp16_ * _tmp17_);
		_tmp18_ = base_multiplier;
		base_multiplier = _tmp18_ * 10;
	}
	_tmp19_ = base_multiplier;
	if (_tmp19_ == 1) {
		number_base = default_base;
	}
	negate = FALSE;
	index = 0;
	string_get_next_char (str, &index, &_tmp20_);
	c = _tmp20_;
	_tmp21_ = c;
	if (_tmp21_ == ((gunichar) '+')) {
		negate = FALSE;
	} else {
		gboolean _tmp22_ = FALSE;
		gunichar _tmp23_;
		_tmp23_ = c;
		if (_tmp23_ == ((gunichar) '-')) {
			_tmp22_ = TRUE;
		} else {
			gunichar _tmp24_;
			_tmp24_ = c;
			_tmp22_ = _tmp24_ == 8722U;
		}
		if (_tmp22_) {
			negate = TRUE;
		} else {
			gunichar _tmp25_ = 0U;
			string_get_prev_char (str, &index, &_tmp25_);
			c = _tmp25_;
		}
	}
	_tmp26_ = number_new_integer ((gint64) 0, (gint64) 0);
	z = _tmp26_;
	while (TRUE) {
		gunichar _tmp27_ = 0U;
		gboolean _tmp28_;
		gint i = 0;
		gunichar _tmp29_;
		gint _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		Number* _tmp35_;
		gint _tmp36_;
		Number* _tmp37_;
		Number* _tmp38_;
		gint _tmp39_;
		Number* _tmp40_;
		Number* _tmp41_;
		Number* _tmp42_;
		_tmp28_ = string_get_next_char (str, &index, &_tmp27_);
		c = _tmp27_;
		if (!_tmp28_) {
			break;
		}
		_tmp29_ = c;
		_tmp30_ = number_base;
		i = char_val (_tmp29_, _tmp30_);
		_tmp31_ = i;
		_tmp32_ = number_base;
		if (_tmp31_ > _tmp32_) {
			result = NULL;
			_g_object_unref0 (z);
			return result;
		}
		_tmp33_ = i;
		if (_tmp33_ < 0) {
			gunichar _tmp34_ = 0U;
			string_get_prev_char (str, &index, &_tmp34_);
			c = _tmp34_;
			break;
		}
		_tmp35_ = z;
		_tmp36_ = number_base;
		_tmp37_ = number_multiply_integer (_tmp35_, (gint64) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		_tmp40_ = number_new_integer ((gint64) _tmp39_, (gint64) 0);
		_tmp41_ = _tmp40_;
		_tmp42_ = number_add (_tmp38_, _tmp41_);
		_g_object_unref0 (z);
		z = _tmp42_;
		_g_object_unref0 (_tmp41_);
		_g_object_unref0 (_tmp38_);
	}
	has_fraction = FALSE;
	_tmp44_ = string_get_next_char (str, &index, &_tmp43_);
	c = _tmp43_;
	if (_tmp44_) {
		gunichar _tmp61_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp45_ = FALSE;
				_tmp45_ = TRUE;
				while (TRUE) {
					gint _tmp47_;
					gunichar _tmp48_;
					gint _tmp49_;
					gunichar _tmp50_;
					if (!_tmp45_) {
						gint _tmp46_;
						_tmp46_ = i;
						i = _tmp46_ + 1;
					}
					_tmp45_ = FALSE;
					_tmp47_ = i;
					if (!(_tmp47_ < G_N_ELEMENTS (fractions))) {
						break;
					}
					_tmp48_ = c;
					_tmp49_ = i;
					_tmp50_ = fractions[_tmp49_];
					if (_tmp48_ == _tmp50_) {
						Number* fraction = NULL;
						gint _tmp51_;
						gint _tmp52_;
						gint _tmp53_;
						gint _tmp54_;
						Number* _tmp55_;
						Number* _tmp56_;
						Number* _tmp57_;
						Number* _tmp58_;
						gunichar _tmp59_ = 0U;
						gboolean _tmp60_;
						_tmp51_ = i;
						_tmp52_ = numerators[_tmp51_];
						_tmp53_ = i;
						_tmp54_ = denominators[_tmp53_];
						_tmp55_ = number_new_fraction ((gint64) _tmp52_, (gint64) _tmp54_);
						fraction = _tmp55_;
						_tmp56_ = z;
						_tmp57_ = fraction;
						_tmp58_ = number_add (_tmp56_, _tmp57_);
						_g_object_unref0 (z);
						z = _tmp58_;
						_tmp60_ = string_get_next_char (str, &index, &_tmp59_);
						c = _tmp59_;
						if (!_tmp60_) {
							result = z;
							_g_object_unref0 (fraction);
							return result;
						} else {
							result = NULL;
							_g_object_unref0 (fraction);
							_g_object_unref0 (z);
							return result;
						}
						_g_object_unref0 (fraction);
					}
				}
			}
		}
		_tmp61_ = c;
		if (_tmp61_ == ((gunichar) '.')) {
			has_fraction = TRUE;
		} else {
			gunichar _tmp62_ = 0U;
			string_get_prev_char (str, &index, &_tmp62_);
			c = _tmp62_;
		}
	}
	_tmp63_ = has_fraction;
	if (_tmp63_) {
		Number* numerator = NULL;
		Number* _tmp64_;
		Number* denominator = NULL;
		Number* _tmp65_;
		Number* _tmp83_;
		Number* _tmp84_;
		Number* _tmp85_;
		Number* _tmp86_;
		Number* _tmp87_;
		Number* _tmp88_;
		_tmp64_ = number_new_integer ((gint64) 0, (gint64) 0);
		numerator = _tmp64_;
		_tmp65_ = number_new_integer ((gint64) 1, (gint64) 0);
		denominator = _tmp65_;
		while (TRUE) {
			gunichar _tmp66_ = 0U;
			gboolean _tmp67_;
			gint i = 0;
			gunichar _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			Number* _tmp72_;
			gint _tmp73_;
			Number* _tmp74_;
			Number* _tmp75_;
			gint _tmp76_;
			Number* _tmp77_;
			Number* _tmp78_;
			gint _tmp79_;
			Number* _tmp80_;
			Number* _tmp81_;
			Number* _tmp82_;
			_tmp67_ = string_get_next_char (str, &index, &_tmp66_);
			c = _tmp66_;
			if (!_tmp67_) {
				break;
			}
			_tmp68_ = c;
			_tmp69_ = number_base;
			i = char_val (_tmp68_, _tmp69_);
			_tmp70_ = i;
			if (_tmp70_ < 0) {
				gunichar _tmp71_ = 0U;
				string_get_prev_char (str, &index, &_tmp71_);
				c = _tmp71_;
				break;
			}
			_tmp72_ = denominator;
			_tmp73_ = number_base;
			_tmp74_ = number_multiply_integer (_tmp72_, (gint64) _tmp73_);
			_g_object_unref0 (denominator);
			denominator = _tmp74_;
			_tmp75_ = numerator;
			_tmp76_ = number_base;
			_tmp77_ = number_multiply_integer (_tmp75_, (gint64) _tmp76_);
			_g_object_unref0 (numerator);
			numerator = _tmp77_;
			_tmp78_ = numerator;
			_tmp79_ = i;
			_tmp80_ = number_new_integer ((gint64) _tmp79_, (gint64) 0);
			_tmp81_ = _tmp80_;
			_tmp82_ = number_add (_tmp78_, _tmp81_);
			_g_object_unref0 (numerator);
			numerator = _tmp82_;
			_g_object_unref0 (_tmp81_);
		}
		_tmp83_ = numerator;
		_tmp84_ = denominator;
		_tmp85_ = number_divide (_tmp83_, _tmp84_);
		_g_object_unref0 (numerator);
		numerator = _tmp85_;
		_tmp86_ = z;
		_tmp87_ = numerator;
		_tmp88_ = number_add (_tmp86_, _tmp87_);
		_g_object_unref0 (z);
		z = _tmp88_;
		_g_object_unref0 (denominator);
		_g_object_unref0 (numerator);
	}
	_tmp89_ = index;
	_tmp90_ = end;
	if (_tmp89_ != _tmp90_) {
		result = NULL;
		_g_object_unref0 (z);
		return result;
	}
	_tmp91_ = negate;
	if (_tmp91_) {
		Number* _tmp92_;
		Number* _tmp93_;
		_tmp92_ = z;
		_tmp93_ = number_invert_sign (_tmp92_);
		_g_object_unref0 (z);
		z = _tmp93_;
	}
	result = z;
	return result;
}


gint
char_val (gunichar c,
          gint number_base)
{
	gint result = 0;
	gint value = 0;
	gint _tmp0_;
	if (!g_unichar_isxdigit (c)) {
		result = -1;
		return result;
	}
	value = g_unichar_xdigit_value (c);
	_tmp0_ = value;
	if (_tmp0_ >= number_base) {
		result = -1;
		return result;
	}
	result = value;
	return result;
}


Number*
set_from_sexagesimal (const gchar* str)
{
	Number* result = NULL;
	gint degree_index = 0;
	gint _tmp0_;
	Number* degrees = NULL;
	gint _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	Number* _tmp4_;
	Number* _tmp5_;
	Number* _tmp6_;
	gint minute_start = 0;
	gint _tmp7_;
	gunichar c = 0U;
	gunichar _tmp8_ = 0U;
	gint _tmp9_;
	gint minute_index = 0;
	gint _tmp10_;
	gint _tmp11_;
	Number* minutes = NULL;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	Number* _tmp17_;
	Number* _tmp18_;
	Number* _tmp19_;
	Number* _tmp20_;
	Number* _tmp21_;
	Number* _tmp22_;
	Number* _tmp23_;
	Number* _tmp24_;
	gint second_start = 0;
	gint _tmp25_;
	gunichar _tmp26_ = 0U;
	gint _tmp27_;
	gint second_index = 0;
	gint _tmp28_;
	gint _tmp29_;
	Number* seconds = NULL;
	gint _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	Number* _tmp35_;
	Number* _tmp36_;
	Number* _tmp37_;
	Number* _tmp38_;
	Number* _tmp39_;
	Number* _tmp40_;
	Number* _tmp41_;
	Number* _tmp42_;
	gunichar _tmp43_ = 0U;
	gint _tmp44_;
	g_return_val_if_fail (str != NULL, NULL);
	degree_index = string_index_of_char (str, 176U, 0);
	_tmp0_ = degree_index;
	if (_tmp0_ < 0) {
		result = NULL;
		return result;
	}
	_tmp1_ = degree_index;
	_tmp2_ = string_substring (str, (glong) 0, (glong) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = mp_set_from_string (_tmp3_, 10);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	degrees = _tmp5_;
	_tmp6_ = degrees;
	if (_tmp6_ == NULL) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp7_ = degree_index;
	minute_start = _tmp7_;
	string_get_next_char (str, &minute_start, &_tmp8_);
	c = _tmp8_;
	_tmp9_ = minute_start;
	if (string_get (str, (glong) _tmp9_) == '\0') {
		result = degrees;
		return result;
	}
	_tmp10_ = minute_start;
	minute_index = string_index_of_char (str, (gunichar) '\'', _tmp10_);
	_tmp11_ = minute_index;
	if (_tmp11_ < 0) {
		result = NULL;
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp12_ = minute_start;
	_tmp13_ = minute_index;
	_tmp14_ = minute_start;
	_tmp15_ = string_substring (str, (glong) _tmp12_, (glong) (_tmp13_ - _tmp14_));
	_tmp16_ = _tmp15_;
	_tmp17_ = mp_set_from_string (_tmp16_, 10);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp16_);
	minutes = _tmp18_;
	_tmp19_ = minutes;
	if (_tmp19_ == NULL) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp20_ = degrees;
	_tmp21_ = minutes;
	_tmp22_ = number_divide_integer (_tmp21_, (gint64) 60);
	_tmp23_ = _tmp22_;
	_tmp24_ = number_add (_tmp20_, _tmp23_);
	_g_object_unref0 (degrees);
	degrees = _tmp24_;
	_g_object_unref0 (_tmp23_);
	_tmp25_ = minute_index;
	second_start = _tmp25_;
	string_get_next_char (str, &second_start, &_tmp26_);
	c = _tmp26_;
	_tmp27_ = second_start;
	if (string_get (str, (glong) _tmp27_) == '\0') {
		result = degrees;
		_g_object_unref0 (minutes);
		return result;
	}
	_tmp28_ = second_start;
	second_index = string_index_of_char (str, (gunichar) '"', _tmp28_);
	_tmp29_ = second_index;
	if (_tmp29_ < 0) {
		result = NULL;
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp30_ = second_start;
	_tmp31_ = second_index;
	_tmp32_ = second_start;
	_tmp33_ = string_substring (str, (glong) _tmp30_, (glong) (_tmp31_ - _tmp32_));
	_tmp34_ = _tmp33_;
	_tmp35_ = mp_set_from_string (_tmp34_, 10);
	_tmp36_ = _tmp35_;
	_g_free0 (_tmp34_);
	seconds = _tmp36_;
	_tmp37_ = seconds;
	if (_tmp37_ == NULL) {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_tmp38_ = degrees;
	_tmp39_ = seconds;
	_tmp40_ = number_divide_integer (_tmp39_, (gint64) 3600);
	_tmp41_ = _tmp40_;
	_tmp42_ = number_add (_tmp38_, _tmp41_);
	_g_object_unref0 (degrees);
	degrees = _tmp42_;
	_g_object_unref0 (_tmp41_);
	string_get_next_char (str, &second_index, &_tmp43_);
	c = _tmp43_;
	_tmp44_ = second_index;
	if (string_get (str, (glong) _tmp44_) == '\0') {
		result = degrees;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		return result;
	} else {
		result = NULL;
		_g_object_unref0 (seconds);
		_g_object_unref0 (minutes);
		_g_object_unref0 (degrees);
		return result;
	}
	_g_object_unref0 (seconds);
	_g_object_unref0 (minutes);
	_g_object_unref0 (degrees);
}


gboolean
mp_is_overflow (Number* x,
                gint wordlen)
{
	gboolean result = FALSE;
	Number* t2 = NULL;
	Number* _tmp0_;
	Number* _tmp1_;
	Number* _tmp2_;
	Number* _tmp3_;
	g_return_val_if_fail (x != NULL, FALSE);
	_tmp0_ = number_new_integer ((gint64) 2, (gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = number_xpowy_integer (_tmp1_, (gint64) wordlen);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	t2 = _tmp3_;
	result = number_compare (t2, x) > 0;
	_g_object_unref0 (t2);
	return result;
}



