/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/* $Source: src/import/chips/p9/procedures/hwp/lib/p9_hcd_memmap_base.H $ */
/*                                                                        */
/* OpenPOWER HostBoot Project                                             */
/*                                                                        */
/* Contributors Listed Below - COPYRIGHT 2015,2017                        */
/* [+] International Business Machines Corp.                              */
/*                                                                        */
/*                                                                        */
/* Licensed under the Apache License, Version 2.0 (the "License");        */
/* you may not use this file except in compliance with the License.       */
/* You may obtain a copy of the License at                                */
/*                                                                        */
/*     http://www.apache.org/licenses/LICENSE-2.0                         */
/*                                                                        */
/* Unless required by applicable law or agreed to in writing, software    */
/* distributed under the License is distributed on an "AS IS" BASIS,      */
/* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or        */
/* implied. See the License for the specific language governing           */
/* permissions and limitations under the License.                         */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
///
/// @file   p9_hcd_memmap_base.H
/// @brief  defines region constants shared by different memory components.
///

// *HWP HWP Owner:        David Du   <daviddu@us.ibm.com>
// *HWP Backup HWP Owner: Greg Still <stillgs@us.ibm.com>
// *HWP FW Owner:         Prem S Jha <premjha2@in.ibm.com>
// *HWP Team:             PM
// *HWP Level:            2
// *HWP Consumed by:      PM:Hostboot:Phyp

#ifndef __HCD_MEMMAP_BASE_H__
#define __HCD_MEMMAP_BASE_H__

#include <p9_hcd_header_defs.H>

// -------------------------------------------------------------------
// Note: There can be NO semicolons(";") at end of macros in this file
//       There can ONLY have HCD_CONST/HCD_CONST64 macros in this file
// -------------------------------------------------------------------

/// Image Magic Numbers

HCD_CONST64(CPMR_MAGIC_NUMBER,                  ULL(0x43504d525f312e30))  // CPMR_1.0
HCD_CONST64(CME_MAGIC_NUMBER ,                  ULL(0x434d455f5f312e30))  // CME__1.0

HCD_CONST64(QPMR_MAGIC_NUMBER,                  ULL(0x51504d525f312e30))  // QPMR_1.0
HCD_CONST64(SGPE_MAGIC_NUMBER,                  ULL(0x534750455f312e30))  // SGPE_1.0

HCD_CONST64(PPMR_MAGIC_NUMBER,                  ULL(0x50504d525f312e30))  // PPMR_1.0
HCD_CONST64(PGPE_MAGIC_NUMBER,                  ULL(0x504750455F312E30))  // PGPE_1.0

HCD_CONST(CME_BUILD_VERSION,                    0x001) // CME__1.0
HCD_CONST(SGPE_BUILD_VERSION,                   0x002) // SGPE_1.0
HCD_CONST(PGPE_BUILD_VERSION,                   0x001) // PGPE_1.0

HCD_CONST64(CPMR_MAGIC_NUMBER_BASE,                  ULL(0x43504d525f302e30))  // CPMR_0.0
HCD_CONST(CPMR_REGION_CHECK_WORD,                    (0x43504d52))          // CPMR
HCD_CONST64(CME_MAGIC_NUMBER_BASE ,                  ULL(0x434d455f5f302e30))  // CME__0.0
HCD_CONST64(QPMR_MAGIC_NUMBER_BASE,                  ULL(0x51504d525f302e30))  // QPMR_0.0
HCD_CONST64(SGPE_MAGIC_NUMBER_BASE,                  ULL(0x534750455f302e30))  // SGPE_0.0
HCD_CONST64(PPMR_MAGIC_NUMBER_BASE,                  ULL(0x50504d525f302e30))  // PPMR_0.0
HCD_CONST64(PGPE_MAGIC_NUMBER_BASE,                  ULL(0x504750455F302E30))  // PGPE_0.0

/// Size constants

HCD_CONST(HALF_KB,                              512)
HCD_CONST(ONE_KB,                               1024)
HCD_CONST(HALF_MB,                              (1024 * 512))
HCD_CONST(ONE_MB,                               (1024 * 1024))
HCD_CONST(TWO_MB,                               (2 * 1024 * 1024))

/// Memory constants

HCD_CONST(CME_SRAM_SIZE,                        (32 * ONE_KB))
HCD_CONST(OCC_SRAM_SIZE,                        (768 * ONE_KB))

HCD_CONST(HOMER_MEMORY_SIZE,                    (4 * ONE_MB))
HCD_CONST(HOMER_OPMR_REGION_NUM,                0)
HCD_CONST(HOMER_QPMR_REGION_NUM,                1)
HCD_CONST(HOMER_CPMR_REGION_NUM,                2)
HCD_CONST(HOMER_PPMR_REGION_NUM,                3)

/// Chip constants

HCD_CONST(MAX_THREADS_PER_CORE,                 4)
HCD_CONST(MAX_CORES_PER_CHIP,                   24)

HCD_CONST(MAX_CMES_PER_CHIP,                    12)
HCD_CONST(MAX_EXES_PER_CHIP,                    12)

HCD_CONST(MAX_QUADS_PER_CHIP,                   6)
HCD_CONST(MAX_CACHES_PER_CHIP,                  6)

HCD_CONST(MAX_CORES_PER_CME,                    2)
HCD_CONST(MAX_CORES_PER_EX,                     2)

HCD_CONST(MAX_CMES_PER_QUAD,                    2)
HCD_CONST(MAX_EXES_PER_QUAD,                    2)

HCD_CONST(CACHE0_CHIPLET_ID,                    0x10)
HCD_CONST(CACHE_CHIPLET_ID_MIN,                 0x10)
HCD_CONST(CACHE_CHIPLET_ID_MAX,                 0x15)

HCD_CONST(CORE0_CHIPLET_ID,                     0x20)
HCD_CONST(CORE_CHIPLET_ID_MIN,                  0x20)
HCD_CONST(CORE_CHIPLET_ID_MAX,                  0x37)

HCD_CONST(MAX_QUAD_ID_SUPPORTED,                5)
HCD_CONST(MAX_CORE_ID_SUPPORTED,                23)
HCD_CONST(MAX_THREAD_ID_SUPPORTED,              3)

/// Image build constants

HCD_CONST(HARDWARE_IMG_SIZE,                    ONE_MB)

HCD_CONST(FUSED_CORE_MODE,                      0xBB)
HCD_CONST(NONFUSED_CORE_MODE,                   0xAA)

HCD_CONST(SELF_RESTORE_BLR_INST,                0x4e800020)
HCD_CONST(CORE_RESTORE_PAD_OPCODE,              0x00000200) //ATTN Opcode

HCD_CONST(SCOM_RESTORE_PAD_OPCODE,              0x00000000) //zero pads
HCD_CONST(SCOM_RESTORE_ENTRY_SIZE,              16)         //4B pad,4B address,8B data

HCD_CONST(CME_BLOCK_READ_LEN,                   32)
HCD_CONST(CME_BLK_SIZE_SHIFT,                   0x05)

HCD_CONST(RING_ALIGN_BOUNDARY,                  0x08)
HCD_CONST64(DARN_BAR_EN_POS,                    ULL(0x8000000000000000))

//---------------------------------------------------------------------------------------

/// OPMR

HCD_CONST(OCC_HOST_AREA_SIZE,                   ONE_MB)
HCD_CONST(OPMR_OCC_IMAGE_SIZE,                  HALF_MB)
HCD_CONST(OPMR_HOST_AREA_SIZE,                  HALF_MB)

//---------------------------------------------------------------------------------------

/// QPMR Header

HCD_CONST(QPMR_HOMER_OFFSET,                    (HOMER_QPMR_REGION_NUM* ONE_MB))
HCD_CONST(QPMR_HEADER_SIZE,                     512)

HCD_CONST(QPMR_MAGIC_NUMBER_BYTE,               0x00)
HCD_CONST(QPMR_BOOT_COPIER_OFFSET_BYTE,         0x08)
HCD_CONST(QPMR_BOOT_LOADER_OFFSET_BYTE,         0x10)
HCD_CONST(QPMR_BOOT_LOADER_LENGTH_BYTE,         0x14)
HCD_CONST(QPMR_BUILD_DATE_BYTE,                 0x18)
HCD_CONST(QPMR_BUILD_VER_BYTE,                  0x1C)
HCD_CONST(QPMR_SGPE_HCODE_OFFSET_BYTE,          0x28)
HCD_CONST(QPMR_SGPE_HCODE_LENGTH_BYTE,          0x2C)
HCD_CONST(QPMR_QUAD_COMMON_RINGS_OFFSET_BYTE,   0x30)
HCD_CONST(QPMR_QUAD_COMMON_RINGS_LENGTH_BYTE,   0x34)
HCD_CONST(QPMR_QUAD_OVERRIDE_RINGS_OFFSET_BYTE, 0x38)
HCD_CONST(QPMR_QUAD_OVERRIDE_RINGS_LENGTH_BYTE, 0x3C)
HCD_CONST(QPMR_QUAD_SPECIFIC_RINGS_OFFSET_BYTE, 0x40)
HCD_CONST(QPMR_QUAD_SPECIFIC_RINGS_LENGTH_BYTE, 0x44)
HCD_CONST(QPMR_QUAD_SCOM_RESTORE_OFFSET_BYTE,   0x48)
HCD_CONST(QPMR_QUAD_SCOM_RESTORE_LENGTH_BYTE,   0x4C)
HCD_CONST(QPMR_AUX_DATA_OFFSET_BYTE,            0x50)
HCD_CONST(QPMR_AUX_DATA_LENGTH_BYTE,            0x54)
HCD_CONST(QPMR_STOP_FFDC_OFFSET_BYTE,           0x58)
HCD_CONST(QPMR_STOP_FFDC_LENGTH_BYTE,           0x5C)
HCD_CONST(QPMR_SGPE_BOOT_PROG_CODE,             0x60)
HCD_CONST(QPMR_SGPE_IMAGE_SIZE,                 0x64)

/// SGPE Boot

HCD_CONST(SGPE_BOOT_COPIER_QPMR_OFFSET,         QPMR_HEADER_SIZE)
HCD_CONST(SGPE_BOOT_COPIER_SIZE,                ONE_KB)

HCD_CONST(SGPE_BOOT_LOADER_QPMR_OFFSET,
          (SGPE_BOOT_COPIER_QPMR_OFFSET + SGPE_BOOT_COPIER_SIZE))
HCD_CONST(SGPE_BOOT_LOADER_SIZE,                ONE_KB)
HCD_CONST(SGPE_BOOT_LOADER_RESET_ADDR_VAL,      0x40)

HCD_CONST(SGPE_INSTRUMENTATION_SIZE,            (2 * ONE_KB))

/// SGPE Image

HCD_CONST(SGPE_IMAGE_QPMR_OFFSET,
          (SGPE_BOOT_LOADER_QPMR_OFFSET + SGPE_BOOT_LOADER_SIZE))
HCD_CONST(SGPE_IMAGE_SIZE,                      (80 * ONE_KB)) //RTC158543
HCD_CONST(SGPE_INT_VECTOR_SIZE,                 384)
HCD_CONST(SGPE_HCODE_RESET_ADDR_VAL,            0x40)

/// SGPE Header

HCD_CONST(SGPE_HEADER_QPMR_OFFSET,
          (SGPE_IMAGE_QPMR_OFFSET + SGPE_INT_VECTOR_SIZE))
HCD_CONST(SGPE_HEADER_IMAGE_OFFSET,             SGPE_INT_VECTOR_SIZE)
HCD_CONST(SGPE_HEADER_SIZE,                     128)

HCD_CONST(SGPE_MAGIC_NUMBER_BYTE,               0x00)
HCD_CONST(SGPE_SYSTEM_RESET_ADDR_BYTE,          0x08)
HCD_CONST(SGPE_IVPR_ADDR_BYTE,                  0x10)
HCD_CONST(SGPE_BUILD_DATE_BYTE,                 0x18)
HCD_CONST(SGPE_BUILD_VER_BYTE,                  0x1C)
HCD_CONST(SGPE_STOP_FLAGS_BYTE,                 0x20)
HCD_CONST(SGPE_LOCATION_ID_BYTE,                0x24)
HCD_CONST(SGPE_QUAD_COMMON_RING_SRAM_OFF_BYTE,  0x28)
HCD_CONST(SGPE_QUAD_OVERRIDE_RING_SRAM_OFF_BYTE, 0x2C)
HCD_CONST(SGPE_QUAD_SPECIFIC_RING_SRAM_OFF_BYTE, 0x30)
HCD_CONST(SGPE_QUAD_SCOM_RESTORE_SRAM_OFF_BYTE, 0x34)
HCD_CONST(SGPE_QUAD_SCOM_RESTORE_MEM_OFF_BYTE,  0x38)
HCD_CONST(SGPE_QUAD_SCOM_RESTORE_LENGTH_BYTE,   0x3C)
HCD_CONST(SGPE_AUX_DATA_OFFSET_BYTE,            0x40)
HCD_CONST(SGPE_AUX_DATA_LENGTH_BYTE,            0x44)
HCD_CONST(SGPE_AUX_CTRL_BYTE,                   0x48)
HCD_CONST(SGPE_CHTM_MEM_CFG_BYTE,               0x50)

HCD_CONST(SGPE_RESET_ADDR_IMAGE_OFFSET,         (SGPE_HEADER_IMAGE_OFFSET + SGPE_SYSTEM_RESET_ADDR_BYTE))
HCD_CONST(SGPE_BUILD_DATE_IMAGE_OFFSET,         (SGPE_HEADER_IMAGE_OFFSET + SGPE_BUILD_DATE_BYTE))
HCD_CONST(SGPE_BUILD_VER_IMAGE_OFFSET,          (SGPE_HEADER_IMAGE_OFFSET + SGPE_BUILD_VER_BYTE))

HCD_CONST(SGPE_STOP_4_TO_2_BIT_POS,             0x80000000)
HCD_CONST(SGPE_STOP_5_TO_4_BIT_POS,             0x40000000)
HCD_CONST(SGPE_STOP_8_TO_5_BIT_POS,             0x20000000)
HCD_CONST(SGPE_STOP_11_TO_8_BIT_POS,            0x10000000)
HCD_CONST(SGPE_ENABLE_CME_TRACE_ARRAY_BIT_POS,  0x08000000)
HCD_CONST(SGPE_VDM_ENABLE_BIT_POS,              0x04000000)
HCD_CONST(SGPE_ENABLE_CHTM_TRACE_CME_BIT_POS,   0x02000000)
HCD_CONST(SGPE_PROC_FAB_PUMP_MODE_BIT_POS,      0x00004000)
HCD_CONST(SGPE_CACHE_SKEWADJ_DISABLE_BIT_POS,   0x00002000)
HCD_CONST(SGPE_CACHE_DCADJ_DISABLE_BIT_POS,     0x00001000)

///24x7
HCD_CONST(QPMR_AUX_OFFSET,                     (512 * ONE_KB))
HCD_CONST(QPMR_AUX_LENGTH,                     (64  * ONE_KB))
/// SGPE Hcode

HCD_CONST(SGPE_HCODE_IMAGE_OFFSET,              (SGPE_INT_VECTOR_SIZE + SGPE_HEADER_SIZE))
HCD_CONST(SGPE_HCODE_SIZE,                      ((45 * ONE_KB) + HALF_KB)) //RTC158543
HCD_CONST(SGPE_DEBUG_PTRS_OFFSET,               0x200)
HCD_CONST(SGPE_DEBUG_PTRS_SIZE,                 0x24)
HCD_CONST(SGPE_DBG_PTR_AREA_SIZE,               64)

/// Quad Scan

// 400B * 9 rings * 3 types (base, RL, CC)
HCD_CONST(QUAD_COMMON_RING_SIZE,                (13 * ONE_KB))
// 300B * 9 rings
HCD_CONST(QUAD_OVERRIDE_RING_SIZE,              (3 * ONE_KB))
// 1KB/ring * 5 rings/cache
HCD_CONST(QUAD_SPECIFIC_RING_SIZE_PER_QUAD,     ((3 * ONE_KB) + HALF_KB))
HCD_CONST(QUAD_SPECIFIC_RING_SIZE_TOTAL,        (19 * ONE_KB)) //checkme?

/// Quad Scom

HCD_CONST(QUAD_SCOM_RESTORE_QPMR_OFFSET,        (128 * ONE_KB))
HCD_CONST(QUAD_SCOM_RESTORE_HOMER_OFFSET,
          (QUAD_SCOM_RESTORE_QPMR_OFFSET + QPMR_HOMER_OFFSET))

HCD_CONST(MAX_L2_SCOM_ENTRIES,                  16)
HCD_CONST(MAX_L3_SCOM_ENTRIES,                  16)

//HW423686
//Inorder to continue IMA after STOP11 on all four cores of a quad, 2
//EQ SCOM registers need to restored per core. STOP API desgin allowed
//only 15 SCOM restore entries per EQ. Out of total budget, 12 are
//consumed during IPL. Hence it was not possible to manage IMA within
//this limit. As a resolution, limit for EQ SCOM restore entries has
//been changed to 31. Below is the break down for EQ SCOM Restore
//Entries

// Power Management         12
// Core IMA                 08
// PRD FIR Mask             05
// Reserve                  06

HCD_CONST(MAX_EQ_SCOM_ENTRIES,                  31)
HCD_CONST(QUAD_SCOM_RESTORE_REGS_PER_QUAD,
          (MAX_EQ_SCOM_ENTRIES + MAX_L2_SCOM_ENTRIES + MAX_L3_SCOM_ENTRIES + 1))

HCD_CONST(QUAD_SCOM_RESTORE_SIZE_PER_QUAD,
          (SCOM_RESTORE_ENTRY_SIZE* QUAD_SCOM_RESTORE_REGS_PER_QUAD))

HCD_CONST(QUAD_SCOM_RESTORE_SIZE_TOTAL,         (6 * ONE_KB)) //rounded to 6KB

//---------------------------------------------------------------------------------------

/// CPMR Header

HCD_CONST(CPMR_HOMER_OFFSET,                    (HOMER_CPMR_REGION_NUM* ONE_MB))
HCD_CONST(CPMR_HEADER_SIZE,                     256)

HCD_CONST(CPMR_ATTN_WORD0_BYTE,                 0x00)
HCD_CONST(CPMR_ATTN_WORD1_BYTE,                 0x04)
HCD_CONST(CPMR_MAGIC_NUMBER_BYTE,               0x08)
HCD_CONST(CPMR_BUILD_DATE_BYTE,                 0x10)
HCD_CONST(CPMR_BUILD_VER_BYTE,                  0x14)
HCD_CONST(CPMR_CME_HCODE_OFFSET_BYTE,           0x20)
HCD_CONST(CPMR_CME_HCODE_LENGTH_BYTE,           0x24)
HCD_CONST(CPMR_CORE_COMMON_RING_OFFSET_BYTE,    0x28)
HCD_CONST(CPMR_CORE_COMMON_RING_LENGTH_BYTE,    0x2C)
HCD_CONST(CPMR_CME_LOCAL_PSTATE_OFFSET_BYTE,    0x30)
HCD_CONST(CPMR_CME_LOCAL_PSTATE_LENGTH_BYTE,    0x34)
HCD_CONST(CPMR_CORE_SPECIFIC_RING_OFFSET_BYTE,  0x38)
HCD_CONST(CPMR_CORE_SPECIFIC_RING_LENGTH_BYTE,  0x3C)
HCD_CONST(CPMR_CORE_SCOM_RESTORE_OFFSET_BYTE,   0x40)
HCD_CONST(CPMR_CORE_SCOM_RESTORE_LENGTH_BYTE,   0x44)
HCD_CONST(CPMR_SELF_RESTORE_OFFSET_BYTE,        0x48)
HCD_CONST(CPMR_SELF_RESTORE_LENGTH_BYTE,        0x4C)

/// Self Restore

HCD_CONST(SELF_RESTORE_CPMR_OFFSET,             CPMR_HEADER_SIZE)
HCD_CONST(SELF_RESTORE_INT_SIZE,                (8 * ONE_KB))
HCD_CONST(THREAD_LAUNCHER_SIZE,                 256)
HCD_CONST(SELF_RESTORE_CODE_SIZE,
          (SELF_RESTORE_INT_SIZE + THREAD_LAUNCHER_SIZE))

HCD_CONST(CORE_RESTORE_THREAD_AREA_SIZE,        (ONE_KB))
HCD_CONST(CORE_RESTORE_CORE_AREA_SIZE,          (ONE_KB))
HCD_CONST(CORE_RESTORE_SIZE_PER_THREAD,
          (CORE_RESTORE_THREAD_AREA_SIZE + CORE_RESTORE_CORE_AREA_SIZE))
HCD_CONST(SELF_RESTORE_CORE_REGS_SIZE,
          (CORE_RESTORE_SIZE_PER_THREAD*
           MAX_THREADS_PER_CORE* MAX_CORES_PER_CHIP))

HCD_CONST(SELF_RESTORE_SIZE_TOTAL,
          (SELF_RESTORE_CODE_SIZE + SELF_RESTORE_CORE_REGS_SIZE))


/// Core Scom

HCD_CONST(CORE_SCOM_RESTORE_CPMR_OFFSET,        (256 * ONE_KB))
HCD_CONST(CORE_SCOM_RESTORE_HOMER_OFFSET,
          (CORE_SCOM_RESTORE_CPMR_OFFSET + CPMR_HOMER_OFFSET))

HCD_CONST(MAX_CORE_SCOM_ENTRIES,                15)
HCD_CONST(CORE_SCOM_RESTORE_REGS_PER_CORE,      (MAX_CORE_SCOM_ENTRIES + 1))

HCD_CONST(CORE_SCOM_RESTORE_SIZE_PER_CORE,
          (SCOM_RESTORE_ENTRY_SIZE* CORE_SCOM_RESTORE_REGS_PER_CORE)) // 16*16=256
HCD_CONST(CORE_SCOM_RESTORE_SIZE_PER_CME,
          (CORE_SCOM_RESTORE_SIZE_PER_CORE* MAX_CORES_PER_CME))       // 256*2=512

HCD_CONST(CORE_SCOM_RESTORE_SIZE_TOTAL,
          (CORE_SCOM_RESTORE_SIZE_PER_CME* MAX_CMES_PER_CHIP))        // 512*12=6K

/// CME Image

HCD_CONST(CME_IMAGE_CPMR_OFFSET,
          (CORE_SCOM_RESTORE_CPMR_OFFSET + CORE_SCOM_RESTORE_SIZE_TOTAL))
//HCD_CONST(CME_IMAGE_SIZE,                       0)
HCD_CONST(CME_INT_VECTOR_SIZE,                  384)

/// CME Header

HCD_CONST(CME_HEADER_CPMR_OFFSET,
          (CME_IMAGE_CPMR_OFFSET + CME_INT_VECTOR_SIZE))
HCD_CONST(CME_HEADER_IMAGE_OFFSET,              CME_INT_VECTOR_SIZE)
HCD_CONST(CME_HEADER_SIZE,                      128)

HCD_CONST(CME_MAGIC_NUMBER_BYTE,                0x00)
HCD_CONST(CME_HCODE_OFFSET_BYTE,                0x08)
HCD_CONST(CME_HCODE_LENGTH_BYTE,                0x0C)
HCD_CONST(CME_CORE_COMMON_RING_OFFSET_BYTE,     0x10)
HCD_CONST(CME_CORE_OVERRIDE_RING_OFFSET_BYTE,   0x14)
HCD_CONST(CME_CORE_COMMON_RING_LENGTH_BYTE,     0x18)
HCD_CONST(CME_LOCAL_PSTATE_OFFSET_BYTE,         0x1C)
HCD_CONST(CME_LOCAL_PSTATE_LENGTH_BYTE,         0x20)
HCD_CONST(CME_CORE_SPECIFIC_RING_OFFSET_BYTE,   0x24)
HCD_CONST(CME_CORE_SPECIFIC_RING_LENGTH_BYTE,   0x28)
HCD_CONST(CME_CORE_SCOM_RESTORE_OFFSET_BYTE,    0x2C)
HCD_CONST(CME_CORE_SCOM_RESTORE_LENGTH_BYTE,    0x30)
HCD_CONST(CME_STOP_FLAGS_BYTE,                  0x34)
HCD_CONST(CME_LOCATION_ID_BYTE,                 0x38)
HCD_CONST(CME_QM_FLAGS_BYTE,                    0x3A)
HCD_CONST(CME_HOMER_ADDRESS_BYTE,               0x40)

HCD_CONST(CME_HCODE_OFF_IMAGE_OFFSET,           (CME_HEADER_IMAGE_OFFSET + CME_HCODE_OFFSET_BYTE))
HCD_CONST(CME_HCODE_LEN_IMAGE_OFFSET,           (CME_HEADER_IMAGE_OFFSET + CME_HCODE_LENGTH_BYTE))

HCD_CONST(CME_STOP_3_TO_2_BIT_POS,              0x80000000)
HCD_CONST(CME_STOP_4_TO_2_BIT_POS,              0x40000000)
HCD_CONST(CME_STOP_5_TO_4_BIT_POS,              0x20000000)
HCD_CONST(CME_STOP_8_TO_5_BIT_POS,              0x10000000)
HCD_CONST(CME_STOP_11_TO_8_BIT_POS,             0x08000000)
HCD_CONST(CME_VDM_ENABLE_BIT_POS,               0x04000000)
HCD_CONST(CME_STOP_MAPPING_DISABLE_BIT_POS,     0x00000004)
HCD_CONST(CME_QUEUED_SCAN_DISABLE_BIT_POS,      0x00000002)
HCD_CONST(CME_SKIP_CORE_POWEROFF_BIT_POS,       0x00000001)
HCD_CONST(CME_QM_FLAG_RESCLK_ENABLE,            0x8000)
HCD_CONST(CME_QM_FLAG_SYS_IVRM_ENABLE,          0x4000)
HCD_CONST(CME_QM_FLAG_SYS_VDM_ENABLE,           0x2000)
HCD_CONST(CME_QM_FLAG_SYS_WOF_ENABLE,           0x1000)
HCD_CONST(CME_QM_FLAG_SYS_DYN_FMIN_ENABLE,      0x0800)
HCD_CONST(CME_QM_FLAG_SYS_DYN_FMAX_ENABLE,      0x0400)
HCD_CONST(CME_QM_FLAG_SYS_JUMP_PROTECT,         0x0200)

/// CME Hcode

HCD_CONST(CME_HCODE_IMAGE_OFFSET,               (CME_INT_VECTOR_SIZE + CME_HEADER_SIZE))
//HCD_CONST(CME_HCODE_SIZE,                       0)
HCD_CONST(CME_DEBUG_PTRS_OFFSET,                0x200)
HCD_CONST(CME_DEBUG_PTRS_SIZE,                  0x24)
HCD_CONST(CME_INSTRUMENTATION_SIZE,             HALF_KB)
HCD_CONST(CME_SRAM_HCODE_OFFSET,                0)

/// Core Scan

HCD_CONST(CORE_COMMON_RING_SIZE,                (2 * ONE_KB))
HCD_CONST(CORE_OVERRIDE_RING_SIZE,              (1 * ONE_KB))
HCD_CONST(CORE_SPECIFIC_RING_SIZE_PER_CORE,     (1 * ONE_KB))
HCD_CONST(CORE_SPECIFIC_RING_SIZE_TOTAL,        (32 * ONE_KB)) // rounded to 32K

/// Quad P-State

HCD_CONST(CME_QUAD_PSTATE_SIZE,                 HALF_KB)

// CME Hcode + Core Scan + Pstate

HCD_CONST(CME_REGION_SIZE,                      (64 * ONE_KB))

// Debug

HCD_CONST(CPMR_TRACE_REGION_OFFSET,             (512 * ONE_KB))
HCD_CONST(CME_TRACE_REGION_SIZE,                (16 * ONE_KB))
HCD_CONST(CPMR_TRACE_REGION_SIZE,               (CME_TRACE_REGION_SIZE* MAX_CMES_PER_CHIP)) // 192K
HCD_CONST(CPMR_DEBUG_REGION_OFFSET,             CPMR_TRACE_REGION_OFFSET + CPMR_TRACE_REGION_SIZE)
HCD_CONST(CPMR_DEBUG_REGION_SIZE,               (64 * ONE_KB)) // 192K + 64K = 256K


//---------------------------------------------------------------------------------------

/// PPMR Header

HCD_CONST(PPMR_HOMER_OFFSET,                    (HOMER_PPMR_REGION_NUM* ONE_MB))
HCD_CONST(PPMR_HEADER_SIZE,                     512)

HCD_CONST(PPMR_MAGIC_NUMBER_BYTE,               0x00)
HCD_CONST(PPMR_BOOT_COPIER_OFFSET_BYTE,         0x08)
HCD_CONST(PPMR_BOOT_LOADER_OFFSET_BYTE,         0x10)
HCD_CONST(PPMR_BOOT_LOADER_LENGTH_BYTE,         0x14)
HCD_CONST(PPMR_BUILD_DATE_BYTE,                 0x18)
HCD_CONST(PPMR_BUILD_VER_BYTE,                  0x1C)
HCD_CONST(PPMR_PGPE_HCODE_OFFSET_BYTE,          0x28)
HCD_CONST(PPMR_PGPE_HCODE_LENGTH_BYTE,          0x2C)
HCD_CONST(PPMR_GLOBAL_PSTATE_OFFSET_BYTE,       0x30)
HCD_CONST(PPMR_GLOBAL_PSTATE_LENGTH_BYTE,       0x34)
HCD_CONST(PPMR_LOCAL_PSTATE_OFFSET_BYTE,        0x38)
HCD_CONST(PPMR_LOCAL_PSTATE_LENGTH_BYTE,        0x3C)
HCD_CONST(PPMR_OCC_PSTATE_OFFSET_BYTE,          0x40)
HCD_CONST(PPMR_OCC_PSTATE_LENGTH_BYTE,          0x44)
HCD_CONST(PPMR_PSTATE_TABLE_OFFSET_BYTE,        0x48)
HCD_CONST(PPMR_PSTATE_TABLE_LENGTH_BYTE,        0x4C)
HCD_CONST(PPMR_PGPE_SRAM_IMAGE_SIZE_BYTE,       0x50)
HCD_CONST(PPMR_PGPE_BOOT_PROG_CODE_BYTE,        0x54)

/// PGPE Boot

HCD_CONST(PGPE_BOOT_COPIER_PPMR_OFFSET,         PPMR_HEADER_SIZE)
HCD_CONST(PGPE_BOOT_COPIER_SIZE,                ONE_KB)

HCD_CONST(PGPE_BOOT_LOADER_PPMR_OFFSET,
          (PGPE_BOOT_COPIER_PPMR_OFFSET + PGPE_BOOT_COPIER_SIZE))
HCD_CONST(PGPE_BOOT_LOADER_SIZE,                ONE_KB)
HCD_CONST(PGPE_BOOT_LOADER_RESET_ADDR_VAL,      0x40)

HCD_CONST(PGPE_INSTRUMENTATION_SIZE,            (2 * ONE_KB))

/// PGPE Image

HCD_CONST(PGPE_AUX_TASK_SIZE,                   (2 * ONE_KB))
HCD_CONST(PGPE_IMAGE_PPMR_OFFSET,
          (PGPE_BOOT_LOADER_PPMR_OFFSET + PGPE_BOOT_LOADER_SIZE))
HCD_CONST(PGPE_IMAGE_SIZE,                      (48 * ONE_KB)) //RTC158543
HCD_CONST(PGPE_INT_VECTOR_SIZE,                 384)
HCD_CONST(PGPE_HCODE_RESET_ADDR_VAL,            0x40)

/// PGPE Header

HCD_CONST(PGPE_HEADER_IMAGE_OFFSET,             PGPE_INT_VECTOR_SIZE)
HCD_CONST(PGPE_HEADER_PPMR_OFFSET,
          (PGPE_IMAGE_PPMR_OFFSET + PGPE_INT_VECTOR_SIZE))
HCD_CONST(PGPE_HEADER_SIZE,                     128)

HCD_CONST(PGPE_MAGIC_NUMBER_BYTE,               0x00)
HCD_CONST(PGPE_SYSTEM_RESET_ADDR_BYTE,          0x08)
HCD_CONST(PGPE_SHARED_SRAM_ADDR_BYTE,           0x0C)
HCD_CONST(PGPE_IVPR_ADDR_BYTE,                  0x10)
HCD_CONST(PGPE_SHARED_SRAM_LENGTH_BYTE,         0x14)
HCD_CONST(PGPE_BUILD_DATE_BYTE,                 0x18)
HCD_CONST(PGPE_BUILD_VER_BYTE,                  0x1C)
HCD_CONST(PGPE_PGPE_FLAGS_BYTE,                 0x20)
HCD_CONST(PGPE_GLOBAL_PSTATE_SRAM_ADDR_BYTE,    0x28)
HCD_CONST(PGPE_GLOBAL_PSTATE_MEM_OFFSET_BYTE,   0x30)
HCD_CONST(PGPE_GLOBAL_PSTATE_PPB_SIZE_BYTE,     0x34)
HCD_CONST(PGPE_GEN_PSTATE_TABLE_MEM_OFFSET_BYTE, 0x38)
HCD_CONST(PGPE_GEN_PSTATE_TABLE_SIZE_BYTE,      0x3C)
HCD_CONST(PGPE_OCC_PSTATE_TABLE_MEM_OFFSET_BYTE, 0x40)
HCD_CONST(PGPE_OCC_PSTATE_TABLE_SIZE_BYTE,      0x44)
HCD_CONST(PGPE_BEACON_ADDR_BYTE,                0x48)
HCD_CONST(PGPE_ACTUAL_QUAD_STATUS_ADDR_BYTE,    0x4C)
HCD_CONST(PGPE_WOF_TABLE_ADDR_BYTE,             0x50)
HCD_CONST(PGPE_WOF_TABLE_LENGTH_BYTE,           0x54)

HCD_CONST(PGPE_RESET_ADDR_IMAGE_OFFSET,         (PGPE_HEADER_IMAGE_OFFSET + PGPE_SYSTEM_RESET_ADDR_BYTE))
HCD_CONST(PGPE_BUILD_DATE_IMAGE_OFFSET,         (PGPE_HEADER_IMAGE_OFFSET + PGPE_BUILD_DATE_BYTE))
HCD_CONST(PGPE_BUILD_VER_IMAGE_OFFSET,          (PGPE_HEADER_IMAGE_OFFSET + PGPE_BUILD_VER_BYTE))

/// PGPE Hcode

//HCD_CONST(PGPE_HCODE_SIZE,                      (32 * ONE_KB)) //RTC158543
HCD_CONST(PGPE_DBG_PTR_AREA_SIZE,               64)
HCD_CONST(PGPE_GLOBAL_PSTATE_PARAM_BLOCK_SIZE,  (4 * ONE_KB))

/// Pstate Parameter Block + Pstate Table

HCD_CONST(OCC_PSTATE_PARAM_BLOCK_PPMR_OFFSET,   (128 * ONE_KB))
HCD_CONST(OCC_PSTATE_PARAM_BLOCK_SIZE,          (8 * ONE_KB))
HCD_CONST(OCC_PSTATE_PARAM_BLOCK_REGION_SIZE,   (16 * ONE_KB))

HCD_CONST(PGPE_PSTATE_OUTPUT_TABLES_PPMR_OFFSET, (144 * ONE_KB))
HCD_CONST(PGPE_PSTATE_OUTPUT_TABLES_SIZE,       (8 * ONE_KB))
HCD_CONST(PGPE_PSTATE_OUTPUT_TABLES_REGION_SIZE, (16 * ONE_KB))

HCD_CONST(OCC_WOF_TABLES_PPMR_OFFSET,           (768 * ONE_KB))
HCD_CONST(OCC_WOF_TABLES_SIZE,                  (256 * ONE_KB))

HCD_CONST(WOF_TABLE_RESERVE,
          OCC_WOF_TABLES_PPMR_OFFSET - (PGPE_PSTATE_OUTPUT_TABLES_PPMR_OFFSET + PGPE_PSTATE_OUTPUT_TABLES_REGION_SIZE))
HCD_CONST(PGPE_IMAGE_RESERVE_SIZE,
          (OCC_PSTATE_PARAM_BLOCK_PPMR_OFFSET - PGPE_IMAGE_PPMR_OFFSET - PGPE_IMAGE_SIZE - PGPE_AUX_TASK_SIZE))

#endif /* __HCD_MEMMAP_BASE_H__ */
