#!/bin/sh
set -o errexit

###
# Copyright (c) 2020, Emmanuel Gil Peyrot <linkmauve@linkmauve.fr>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# 1. Redistributions of source code must retain the above copyright notice,
# this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright notice,
# this list of conditions and the following disclaimer in the documentation
# and/or other materials provided with the distribution.
#
# This software is provided by the copyright holders and contributors "as is"
# and any express or implied warranties, including, but not limited to, the
# implied warranties of merchantability and fitness for a particular purpose
# are disclaimed. In no event shall the copyright holder or contributors be
# liable for any direct, indirect, incidental, special, exemplary, or
# consequential damages (including, but not limited to, procurement of
# substitute goods or services; loss of use, data, or profits; or business
# interruption) however caused and on any theory of liability, whether in
# contract, strict liability, or tort (including negligence or otherwise)
# arising in any way out of the use of this software, even if advised of the
# possibility of such damage.
###

###
# Touhou 9
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220328.2

# Set game-specific variables

GAME_ID='touhou-9-demo'
GAME_NAME='Touhou Kaeizuka ~ Phantasmagoria of Flower View - Demo'

SCRIPT_DEPS='iconv'

## All download links behind the provided URL seem to be dead,
## despite the download page itself still being available.
ARCHIVE_BASE_0='kaei_ver002.lzh'
ARCHIVE_BASE_0_MD5='e07878f414404ba2157c4f646ccf3708'
ARCHIVE_BASE_0_TYPE='lha'
ARCHIVE_BASE_0_SIZE='29000'
ARCHIVE_BASE_0_VERSION='0.02a-zun1'
ARCHIVE_BASE_0_URL='https://www16.big.or.jp/~zun/html/th09dl.html'

CONTENT_PATH_DEFAULT='kaei'
ARCHIVE_DOC_DATA_FILES='
*.txt
manual'
ARCHIVE_GAME_BIN_FILES='
*.exe'
ARCHIVE_GAME_DATA_FILES='
*.dat'

# Store saved games and settings outside of WINE prefix
CONFIG_FILES='./th09tr.cfg'
DATA_FILES='./log.txt ./score.dat'
DATA_DIRS='./replay'

APP_MAIN_TYPE='wine'
APP_MAIN_PRERUN='export LANG=ja_JP.UTF-8'
APP_MAIN_EXE='th09tr.exe'
APP_MAIN_ICON='th09tr.exe'

APP_CONFIG_ID="${GAME_ID}_config"
APP_CONFIG_TYPE='wine'
APP_CONFIG_PRERUN='export LANG=ja_JP.UTF-8'
APP_CONFIG_EXE='custom.exe'
APP_CONFIG_ICON='custom.exe'
APP_CONFIG_NAME="$GAME_NAME - configuration"
APP_CONFIG_CAT='Settings'

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine libGL.so.1"
PKG_BIN_DEPS_DEB='fonts-wqy-microhei'
PKG_BIN_DEPS_ARCH='wqy-microhei'
PKG_BIN_DEPS_GENTOO='media-fonts/wqy-microhei'

# Load common functions

target_version='2.15'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"

# Convert the text files to UTF-8 encoding

find "$PLAYIT_WORKDIR" \( -name '*.txt' -o -name '*.html' \) -exec \
	sh -c 'contents=$(iconv --from-code CP932 --to-code UTF-8 "$1"); printf "%s" "$contents" > "$1"' -- '{}' \;

# Include game data

prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN' 'APP_CONFIG'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN' 'APP_CONFIG'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
