For the `--server` parameter, you can specify an ACME server directory URL,  and you can also give a short friendly name for known CAs.

The supported short names are:

|    Short Name      |       ACME server URL | Usage Wiki |
|--------------------|    -------------------|------|
| letsencrypt       |  https://acme-v02.api.letsencrypt.org/directory |  N/A |
| letsencrypt_test   | https://acme-staging-v02.api.letsencrypt.org/directory |  N/A |
| zerossl | https://acme.zerossl.com/v2/DV90  | [ZeroSSL.com CA](https://github.com/acmesh-official/acme.sh/wiki/ZeroSSL.com-CA) |
| sslcom | https://acme.ssl.com/sslcom-dv-rsa, https://acme.ssl.com/sslcom-dv-ecc  | [SSL.com CA](https://github.com/acmesh-official/acme.sh/wiki/SSL.com-CA) |
| google | https://dv.acme-v02.api.pki.goog/directory |  [Google Public CA](https://github.com/acmesh-official/acme.sh/wiki/Google-Trust-Services-CA) |
| googletest |  https://dv.acme-v02.test-api.pki.goog/directory | [Google Public CA](https://github.com/acmesh-official/acme.sh/wiki/Google-Trust-Services-CA) | 
| actalis  | https://acme-api.actalis.com/acme/directory  | [Actalis.com CA](https://github.com/acmesh-official/acme.sh/wiki/Actalis.com-CA) |


The short name will be treated as the same as the URL:

The following usages have the same meaning:

```
acme.sh --issue ....   --server  zerossl

-or-

acme.sh --issue ....   --server  https://acme.zerossl.com/v2/DV90
```


For now, the default CA is `zerossl`.   If you want to use another CA, you need to specify `--server` for each command.

For example, if your want to use `letsencrypt` CA :

```
acme.sh  --register-account  --server letsencrypt  -m  myemail@example.com

--or--

acme.sh  --issue --server letsencrypt  -d  example.com  --dns dns_cf

```

There is a way to change the default CA:

```
acme.sh  --set-default-ca  --server letsencrypt
```

From now on,  you will issue cert from `letsencrypt` if you don't specify any `--server` parameter.

```
acme.sh --issue  -d example.com  --dns dns_cf
```



