------------------------------------------------------------------------------
--                                                                          --
--                      GNAT METRICS TOOLS COMPONENTS                       --
--                                                                          --
--                      M E T R I C S . O P T I O N S                       --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                     Copyright (C) 2002-2009, AdaCore                     --
--                                                                          --
-- GNAT Metrics Toolset  is free software;  you can  redistribute it and/or --
-- modify it under terms of the  GNU General Public License as published by --
-- the Free Software Foundation;  either version 2, or (at your option) any --
-- later version.  GNAT Metrics Toolset is  distributed in the hope that it --
-- will be useful, but  WITHOUT ANY WARRANTY; without even the implied war- --
-- ranty of  MERCHANTABILITY or  FITNESS FOR A PARTICULAR PURPOSE.  See the --
-- GNU General Public License for more details.  You should have received a --
-- copy of the  GNU General Public License distributed with  GNAT; see file --
-- COPYING.  If not,  write to the  Free Software  Foundation,  51 Franklin --
-- Street, Fifth Floor, Boston, MA 02110-1301, USA.                         --
--                                                                          --
-- GNAT Metrics Toolset is maintained by AdaCore (http://www.adacore.com).  --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines a set of options for metric tools

package METRICS.Options is

   Short_SFN_In_Output : Boolean := False;
   --  Put short file name in the output information (by default the source
   --  file name in the output information generated by GNATMETRIC contains the
   --  full path).

   Compute_Local_Metrics : Boolean := True;
   --  Indicates if the detailed metrics should be computed for nested
   --  program units.

   ---------------------------
   -- Line metrics settings --
   ---------------------------

   Compute_All_Lines               : Boolean := True;
   Compute_Code_Lines              : Boolean := True;
   Compute_Comment_Lines           : Boolean := True;
   Compute_EOL_Comments            : Boolean := True;
   Compute_Comment_Code_Ratio      : Boolean := True;
   Compute_Blank_Lines             : Boolean := True;
   Compute_Average_Lines_In_Bodies : Boolean := True;

   ------------------------------
   -- Element metrics settings --
   ------------------------------

   Compute_All_Statements      : Boolean := True;
   Compute_All_Declarations    : Boolean := True;
   Compute_Progam_Unit_Nesting : Boolean := True;
   Compute_Construct_Nesting   : Boolean := True;
   Compute_Public_Subprograms  : Boolean := True;
   Compute_All_Subprograms     : Boolean := True;
   Compute_Public_Types        : Boolean := True;
   Compute_All_Types           : Boolean := True;

   ----------------------------------
   --  Complexity metrics settings --
   ----------------------------------

   Compute_Cyclomatic_Complexity : Boolean := True;
   Compute_Essential_Complexity  : Boolean := True;
   Compute_Average_Complexity    : Boolean := True;
   Compute_Loop_Nesting          : Boolean := True;
   Compute_Extra_Exit_Points     : Boolean := True;

   function Line_Metrics_Set return Boolean;
   function Selective_Line_Metrics_Set return Boolean;
   --  These functions are used to simplify conditions used to turn off line
   --  metrics computations (which are rather time-consuming). The first
   --  one says if at least one line metric should be computed, the last one
   --  says if we have to compute the number of lines of a specific type,
   --  that is, if we have to get the list of all the lines and to iterate
   --  through this list
   --
   --  Note, that these function do NOT return true if the only line metric
   --  that is ON is average code line number in bodies.

   function Complexity_Metrics_Set return Boolean;
   --  Checks if at least one complexity metric is set. At the moment we
   --  consider the following metrics as complexity metrics:
   --    cyclomatic complexity
   --    essential complexity
   --    loop nesting

   function Element_Metrics_Set return Boolean;
   --  Checks if at least one syntax element metric is ON

   function Unit_Metrics_Set return Boolean;
   --  Check if at least one metric that should be reported for a compilation
   --  unit is ON

   procedure Complexity_Metrics_Off;
   procedure Element_Metrics_Off;
   procedure Line_Metrics_Off;
   --  Turns OFF all the metrics of the corresponding kind

   procedure Complexity_Metrics_On;
   procedure Element_Metrics_On;
   procedure Line_Metrics_On;
   --  Turns ON all the metrics of the corresponding kind

   ----------------------
   -- Coupling metrics --
   ----------------------

   Compute_Package_Efferent_Coupling  : Boolean := False;
   Compute_Category_Efferent_Coupling : Boolean := False;
   Compute_Package_Afferent_Coupling  : Boolean := False;
   Compute_Category_Afferent_Coupling : Boolean := False;

   procedure Coupling_Metric_On;
   procedure Coupling_Metric_Off;
   --  Turns ON (OFF) all the coupling metrics.

   function Coupling_Metrics_Set return Boolean;
   --  Returns True if at least one coupling metric is ON. Returns False
   --  otherwise.

end METRICS.Options;
