/*
 * (C) Copyright 2013 ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation
 * nor does it submit to any jurisdiction.
 */

/// @file array.h
/// @brief Public API header that includes all relevant headers for using the atlas::array namespace
/// @author Willem Deconinck

/// @namespace atlas::array
/// @brief Contains classes to operate with multidimensional arrays

#pragma once

#include "atlas/array/Array.h"
#include "atlas/array/ArrayDataStore.h"
#include "atlas/array/ArrayShape.h"
#include "atlas/array/ArraySpec.h"
#include "atlas/array/ArrayStrides.h"
#include "atlas/array/ArrayView.h"
#include "atlas/array/DataType.h"
#include "atlas/array/LocalView.h"
#include "atlas/array/MakeView.h"
#include "atlas/array/Table.h"
//#include "atlas/array/TableView.h"
