/*
 * utils/BtException.cpp is part of Brewtarget, and is copyright the following
 * authors 2021:
 * - Matt Young <mfsy@yahoo.com>
 *
 * Brewtarget is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Brewtarget is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#include "utils/BtException.h"

#include <sstream>

#include <boost/stacktrace.hpp>

BtException::BtException(QString const & what_arg) :
   std::runtime_error{what_arg.toStdString()} {
   // Note that we intentionally do not do any logging here.  It is far more useful for logging to be done by the
   // caller as the log message will then include a relevant reference to the source (file name and line number).
   std::ostringstream stack;
   stack << boost::stacktrace::stacktrace();
   this->stackTrace = QString::fromStdString(stack.str());
   return;
}

BtException::~BtException() = default;

QString const & BtException::getStackTrace() const {
   return this->stackTrace;
}
