/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/


//
// $Id: Dataset.H,v 1.30 2003/02/12 23:01:48 vince Exp $
//

// ---------------------------------------------------------------
// Dataset.H
// ---------------------------------------------------------------
#ifndef _DATASET_H_
#define _DATASET_H_

#include <Xm/Xm.h>
#undef index

#include "Dataset.H"
#include "GlobalUtilities.H"
#include "GraphicsAttributes.H"

#include "Box.H"
#include "AmrvisConstants.H"

const int MAXSTRINGWIDTH = 64;

class PltApp;
class PltAppState;
class AmrPicture;
class DataServices;
class StringLoc;	

class Dataset {
 public:
  Dataset(const Box &alignedRegion, AmrPicture *apptr,
          PltApp *pltappptr, PltAppState *pltappstateptr,
	  int hdir, int vdir, int sdir);
  
  ~Dataset();
  
  void DatasetRender(const Box &alignedRegion, AmrPicture *apptr,
		     PltApp *pltappptr, PltAppState *pltappstateptr,
		     int hdir, int vdir, int sdir);
  void DrawIndices();
  void DoRaise();
  void DoExpose(int fromExpose);
  static void CBColorButton(Widget, XtPointer, XtPointer);
  static void CBQuitButton(Widget, XtPointer, XtPointer);
  static void CBPixInput(Widget, XtPointer, XtPointer);
  static void CBEndScrolling(Widget, XtPointer, XtPointer);
  static void CBScrolling(Widget, XtPointer, XtPointer);
  static void CBDoExposeDataset(Widget, XtPointer, XEvent *, Boolean *);
  
  void DoColorButton();
  void DoQuitButton();
  void DoPixInput(XmDrawingAreaCallbackStruct *);

  AmrPicture *GetAmrPicturePtr() { return amrPicturePtr; }

 private:
  Widget	wDatasetTopLevel, wDatasetForm;
  Widget	wDatasetTools, wScrollArea, wPixArea;
  Widget        wFormat, wColorButton, wQuitButton, wLevels, wMinValue, wMaxValue;
  Arg		args[MAXARGS];
  Box		*datasetRegion;
  unsigned int	pixSizeX, pixSizeY;
  int		dataItemWidth, dataItemHeight;
  int		maxAllowableLevel, maxDrawnLevel, minDrawnLevel, stringOk;
  int		noData, hDIR, vDIR, sDIR, numStrings, *myStringCount;
  char		buffer[BUFSIZ], dataString[MAXSTRINGWIDTH];
  StringLoc	*dataStringArray, **myDataStringArray;
  bool          bDataStringArrayAllocated;
  AmrPicture	*amrPicturePtr;
  DataServices	*dataServicesPtr;
  PltApp	*pltAppPtr;
  PltAppState	*pltAppStatePtr;
  GraphicsAttributes	*gaPtr;
  int 		dragging, drags;
  int		hStringOffset, vStringOffset;
  string 	hAxisString, vAxisString;
  int           indexWidth, indexHeight;
  int		hScrollBarPos, vScrollBarPos;
  int		hIndexAreaHeight, hIndexAreaStart, hIndexAreaEnd;
  int		vIndexAreaWidth,  vIndexAreaStart, vIndexAreaEnd;
  int		xh, yv;
  Dimension	width, height;
  StringLoc    **hIndexArray, **vIndexArray;    
  bool datasetPoint;
  Atom          WM_DELETE_WINDOW;

  
  Pixel blackIndex, whiteIndex;
  
  void DrawGrid(int startX, int startY, int finishX, int finishY,
                int gridspacingX, int gridspacingY,
                int foregroundIndex, int backgroundIndex);
  void DrawGrid(int startX, int startY, int finishX, int finishY,
                int refRatio,
                int foregroundIndex, int backgroundIndex);
};


class StringLoc {
public:
  StringLoc()  { }
  ~StringLoc() { }
  char ds[MAXSTRINGWIDTH];
  int xloc, yloc, color, olflag, dslen;
};

#endif
// -------------------------------------------------------------------
// -------------------------------------------------------------------
