/*******************************************************************************
 * Copyright (c) 2006 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.ui.examples.views.properties.tabbed.article.views;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

/**
 * A font property descriptor.
 * 
 * @author Anthony Hunter
 */
public class FontPropertyDescriptor
    extends PropertyDescriptor {

    /**
     * Creates an property descriptor with the given id and display name.
     * 
     * @param id
     *            the id of the property
     * @param displayName
     *            the name to display for the property
     */
    public FontPropertyDescriptor(Object id, String displayName) {
        super(id, displayName);
    }

    /**
     * @see org.eclipse.ui.views.properties.IPropertyDescriptor#createPropertyEditor(Composite)
     */
    public CellEditor createPropertyEditor(Composite parent) {
        CellEditor editor = new FontDialogCellEditor(parent);
        if (getValidator() != null)
            editor.setValidator(getValidator());
        return editor;
    }

}
