/*
 * Decompiled with CFR 0.152.
 */
package opendap.dap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import opendap.dap.BaseType;
import opendap.dap.DataReadException;
import opendap.dap.PrimitiveVector;
import opendap.dap.ServerVersion;
import opendap.dap.StatusUI;

public class BytePrimitiveVector
extends PrimitiveVector
implements Cloneable {
    private byte[] vals;

    public BytePrimitiveVector(BaseType var) {
        super(var);
    }

    public Object clone() {
        BytePrimitiveVector v = (BytePrimitiveVector)super.clone();
        if (this.vals != null) {
            v.vals = new byte[this.vals.length];
            System.arraycopy(this.vals, 0, v.vals, 0, this.vals.length);
        }
        return v;
    }

    public int getLength() {
        return this.vals.length;
    }

    public void setLength(int len) {
        this.vals = new byte[len];
    }

    public final byte getValue(int i) {
        return this.vals[i];
    }

    public final void setValue(int i, byte newVal) {
        this.vals[i] = newVal;
    }

    public void printVal(PrintWriter os, String space) {
        int len = this.vals.length;
        for (int i = 0; i < len - 1; ++i) {
            os.print(this.vals[i] & 0xFF);
            os.print(", ");
        }
        if (len > 0) {
            os.print(this.vals[len - 1] & 0xFF);
        }
    }

    public void printSingleVal(PrintWriter os, int index) {
        os.print(this.vals[index] & 0xFF);
    }

    public synchronized void deserialize(DataInputStream source, ServerVersion sv, StatusUI statusUI) throws IOException, EOFException, DataReadException {
        int modFour = this.vals.length % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        for (int i = 0; i < this.vals.length; ++i) {
            this.vals[i] = source.readByte();
            if (statusUI == null) continue;
            statusUI.incrementByteCount(1);
            if (!statusUI.userCancelled()) continue;
            throw new DataReadException("User cancelled");
        }
        for (int i = 0; i < pad; ++i) {
            byte unused = source.readByte();
        }
        if (statusUI != null) {
            statusUI.incrementByteCount(pad);
        }
    }

    public void externalize(DataOutputStream sink) throws IOException {
        int i;
        int modFour = this.vals.length % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        for (i = 0; i < this.vals.length; ++i) {
            sink.writeByte(this.vals[i]);
        }
        for (i = 0; i < pad; ++i) {
            sink.writeByte(0);
        }
    }

    public void externalize(DataOutputStream sink, int start, int stop, int stride) throws IOException {
        int count = 0;
        for (int i = start; i <= stop; i += stride) {
            sink.writeByte(this.vals[i]);
            ++count;
        }
        int modFour = count % 4;
        int pad = modFour != 0 ? 4 - modFour : 0;
        for (int i = 0; i < pad; ++i) {
            sink.writeByte(0);
        }
    }

    public PrimitiveVector subset(int start, int stop, int stride) {
        BytePrimitiveVector n = new BytePrimitiveVector(this.getTemplate());
        stride = Math.max(stride, 1);
        stop = Math.max(start, stop);
        int length = 1 + (stop - start) / stride;
        n.setLength(length);
        int count = 0;
        for (int i = start; i <= stop; i += stride) {
            n.setValue(count, this.vals[i]);
            ++count;
        }
        return n;
    }

    public Object getInternalStorage() {
        return this.vals;
    }

    public void setInternalStorage(Object o) {
        this.vals = (byte[])o;
    }
}

