/*
 * Decompiled with CFR 0.152.
 */
package visad.data.amanda;

import java.awt.Dimension;
import java.rmi.RemoteException;
import javax.swing.JPanel;
import visad.DataReferenceImpl;
import visad.Display;
import visad.GraphicsModeControl;
import visad.Gridded2DSet;
import visad.MathType;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.amanda.Event;
import visad.data.amanda.F2000Util;
import visad.data.amanda.Hit;
import visad.java2d.DisplayImplJ2D;

public class HistogramWidget
extends JPanel {
    private static final RealType countType = RealType.getRealType("count");
    private static RealTupleType histoType;
    private ScalarMap dpyColorMap;
    private DataReferenceImpl ref;
    private ScalarMap xMap;
    private ScalarMap yMap;
    private ScalarMap cMap;

    public HistogramWidget(ScalarMap dpyColorMap) throws RemoteException, VisADException {
        this.dpyColorMap = dpyColorMap;
        DisplayImplJ2D dpy = new DisplayImplJ2D("histogram");
        this.xMap = new ScalarMap(countType, Display.XAxis);
        this.yMap = new ScalarMap(Hit.leadingEdgeTimeType, Display.YAxis);
        dpy.addMap(this.xMap);
        dpy.addMap(this.yMap);
        this.cMap = new ScalarMap(Hit.leadingEdgeTimeType, Display.RGB);
        dpy.addMap(this.cMap);
        F2000Util.invertColorTable(this.cMap);
        GraphicsModeControl gmc2 = dpy.getGraphicsModeControl();
        gmc2.setScaleEnable(true);
        this.ref = new DataReferenceImpl("histogram");
        dpy.addReference(this.ref);
        JPanel dpyPanel = (JPanel)dpy.getComponent();
        Dimension dim = new Dimension(250, 250);
        dpyPanel.setPreferredSize(dim);
        dpyPanel.setMinimumSize(dim);
        this.add(dpyPanel);
    }

    public void setEvent(Event evt) throws RemoteException, VisADException {
        float[][] histoData = evt.makeHistogram(this.xMap, this.yMap, this.cMap, this.dpyColorMap);
        Gridded2DSet set = new Gridded2DSet((MathType)histoType, histoData, histoData[0].length);
        this.ref.setData(set);
    }

    static {
        try {
            histoType = new RealTupleType(Hit.leadingEdgeTimeType, countType);
        }
        catch (VisADException ve) {
            System.err.println("Couldn't create histogram MathType");
            ve.printStackTrace();
            histoType = null;
        }
    }
}

