/*
 * Decompiled with CFR 0.152.
 */
package visad.data.dods;

import dods.dap.Attribute;
import dods.dap.BaseType;
import dods.dap.DAS;
import java.rmi.RemoteException;
import visad.DataImpl;
import visad.VisADException;
import visad.data.BadFormException;
import visad.data.dods.AttributeAdapterFactory;
import visad.data.dods.VariableAdapterFactory;

public class DataFactory {
    private static final DataFactory instance = new DataFactory();
    private final AttributeAdapterFactory attributeFactory;
    private final VariableAdapterFactory variableFactory;

    protected DataFactory() {
        this(AttributeAdapterFactory.attributeAdapterFactory(), VariableAdapterFactory.variableAdapterFactory());
    }

    protected DataFactory(AttributeAdapterFactory attributeFactory, VariableAdapterFactory variableFactory) {
        this.attributeFactory = attributeFactory;
        this.variableFactory = variableFactory;
    }

    public static DataFactory dataFactory() {
        return instance;
    }

    public static DataFactory dataFactory(AttributeAdapterFactory attributeFactory, VariableAdapterFactory variableFactory) {
        return new DataFactory(attributeFactory, variableFactory);
    }

    public DataImpl data(String name, Attribute attribute, boolean copy) throws BadFormException, VisADException, RemoteException {
        return this.attributeFactory.attributeAdapter(name, attribute).data(copy);
    }

    public DataImpl data(BaseType var, DAS das, boolean copy) throws BadFormException, VisADException, RemoteException {
        return this.variableFactory.variableAdapter(var, das).data(var, copy);
    }
}

