/****************************************************************
 *								*
 *	Copyright 2001, 2011 Fidelity Information Services, Inc	*
 *								*
 *	This source code contains the intellectual property	*
 *	of its copyright holder(s), and is made available	*
 *	under a license.  If you do not know the terms of	*
 *	the license, please stop and do not read further.	*
 *								*
 ****************************************************************/

#include "mdef.h"
#include "compiler.h"
#include "toktyp.h"
#include "advancewindow.h"

int f_fnzbitstr(oprtype *a, opctype op)
{
	triple *r, *parm;
	DCL_THREADGBL_ACCESS;

	SETUP_THREADGBL_ACCESS;
	r = maketriple(op);
	if (EXPR_FAIL == expr(&(r->operand[0]), MUMPS_INT))      /* size */
		return FALSE;
	if (TK_COMMA != TREF(window_token))
		r->operand[1] = put_ilit(0);
	else
	{
		advancewindow();
		if (EXPR_FAIL == expr(&(r->operand[1]), MUMPS_INT))    /* position  */
			return FALSE;
	}
	ins_triple(r);
	*a = put_tref(r);
	return TRUE;
}
