/*************************************************************************
 *                                                                       *
 * Open Dynamics Engine, Copyright (C) 2001,2002 Russell L. Smith.       *
 * All rights reserved.  Email: russ@q12.org   Web: www.q12.org          *
 *                                                                       *
 * This library is free software; you can redistribute it and/or         *
 * modify it under the terms of EITHER:                                  *
 *   (1) The GNU Lesser General Public License as published by the Free  *
 *       Software Foundation; either version 2.1 of the License, or (at  *
 *       your option) any later version. The text of the GNU Lesser      *
 *       General Public License is included with this library in the     *
 *       file LICENSE.TXT.                                               *
 *   (2) The BSD-style license that is included with this library in     *
 *       the file LICENSE-BSD.TXT.                                       *
 *                                                                       *
 * This library is distributed in the hope that it will be useful,       *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the files    *
 * LICENSE.TXT and LICENSE-BSD.TXT for more details.                     *
 *                                                                       *
 *************************************************************************/

#ifndef _ODE_QUICK_STEP_CG_LCP_H_
#define _ODE_QUICK_STEP_CG_LCP_H_

#include <ode/common.h>
#include "quickstep_util.h"

namespace ode {
    namespace quickstep{
#ifdef USE_CG_LCP
        void CG_LCP (dxWorldProcessContext *context,
                int m, int nb, dRealMutablePtr J, int *jb, dxBody * const *body,
                dRealPtr invMOI, dRealMutablePtr lambda, dRealMutablePtr cforce, dRealMutablePtr rhs,
                dRealMutablePtr lo, dRealMutablePtr hi, dRealPtr cfm, int *findex,
                dxQuickStepParameters *qs); 

        size_t quickstep::EstimateGR_LCPMemoryRequirements(int m);
#endif
    } // namespace quickstep
} // namespace ode
#endif