// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_TOC_H
#define _GSTREAMERMM_TOC_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/*
 * toc.hg
 *
 *  Created on: Sep 25, 2013
 *      Author: m.kolny
 */
/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008-20013 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>


namespace Gst
{
  class TocEntry;

  /** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var TocScope TOC_SCOPE_GLOBAL
 *  Global TOC representing all selectable options (this is what applications are usually interested in).
 * 
 *  @var TocScope TOC_SCOPE_CURRENT
 *  TOC for the currently active/selected stream (this is a TOC representing the current stream from start to EOS, and is what a TOC writer / muxer is usually interested in; it will usually be a subset of the global TOC, e.g. just the chapters of the current title, or the chapters selected for playback from the current title).
 * 
 *  @enum TocScope
 * 
 * The scope of a TOC.
 * @ingroup gstreamermmEnums
 */
enum TocScope
{
  TOC_SCOPE_GLOBAL = 1,
  TOC_SCOPE_CURRENT
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TocScope> : public Glib::Value_Enum<Gst::TocScope>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

  /** 
 *  @var TocEntryType TOC_ENTRY_TYPE_ANGLE
 *  Entry is an angle (i.e.\ an alternative).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_VERSION
 *  Entry is a version (i.e. alternative).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_EDITION
 *  Entry is an edition (i.e. alternative).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_INVALID
 *  Invalid entry type value.
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_TITLE
 *  Entry is a title (i.e. a part of a sequence).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_TRACK
 *  Entry is a track (i.e. a part of a sequence).
 * 
 *  @var TocEntryType TOC_ENTRY_TYPE_CHAPTER
 *  Entry is a chapter (i.e. a part of a sequence).
 * 
 *  @enum TocEntryType
 * 
 * The different types of TOC entries (see Gst::TocEntry).
 * 
 * There are two types of TOC entries: alternatives or parts in a sequence.
 * @ingroup gstreamermmEnums
 */
enum TocEntryType
{
  TOC_ENTRY_TYPE_ANGLE = -3,
  TOC_ENTRY_TYPE_VERSION,
  TOC_ENTRY_TYPE_EDITION,
  TOC_ENTRY_TYPE_INVALID,
  TOC_ENTRY_TYPE_TITLE,
  TOC_ENTRY_TYPE_TRACK,
  TOC_ENTRY_TYPE_CHAPTER
};

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::TocEntryType> : public Glib::Value_Enum<Gst::TocEntryType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


class Toc : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Toc CppObjectType;
  typedef GstToc BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstToc*       gobj();

  ///Provides access to the underlying C instance.
  const GstToc* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstToc* gobj_copy() const;

protected:
  // Do not derive this.  Gst::Toc can neither be constructed nor deleted.
  Toc();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  Toc(const Toc&);
  Toc& operator=(const Toc&);


public:
  
  /** Appends the Gst::TocEntry @a entry to @a toc.
   * 
   * @param entry A Gst::TocEntry.
   */
  void append_entry(Glib::RefPtr<Gst::TocEntry> entry);
  
  void dump();
  
  void dump() const;


};

class TocEntry : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef TocEntry CppObjectType;
  typedef GstTocEntry BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstTocEntry*       gobj();

  ///Provides access to the underlying C instance.
  const GstTocEntry* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstTocEntry* gobj_copy() const;

protected:
  // Do not derive this.  Gst::TocEntry can neither be constructed nor deleted.
  TocEntry();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  TocEntry(const TocEntry&);
  TocEntry& operator=(const TocEntry&);


public:
  
  /** 
   * 
   * @return  @a entry's entry type.
   */
  TocEntryType get_entry_type();
  
  /** Gets the UID of @a entry.
   * 
   * @return The UID of @a entry.
   */
  Glib::ustring get_uid();
  
  /** Appends the Gst::TocEntry @a subentry to @a entry.
   * 
   * @param subentry A Gst::TocEntry.
   */
  void append_sub_entry(Glib::RefPtr<Gst::TocEntry> entry);

  
  /** 
   * 
   * @return <tt>true</tt> if @a entry's type is an alternative type, otherwise <tt>false</tt>.
   */
  bool is_alternative();
  
  /** 
   * 
   * @return <tt>true</tt> if @a entry's type is an alternative type, otherwise <tt>false</tt>.
   */
  bool is_alternative() const;

  
  /** 
   * 
   * @return <tt>true</tt> if @a entry's type is a sequence type, otherwise <tt>false</tt>.
   */
  bool is_sequence();
  
  /** 
   * 
   * @return <tt>true</tt> if @a entry's type is a sequence type, otherwise <tt>false</tt>.
   */
  bool is_sequence() const;

  
  /** Gets the parent Gst::TocEntry of @a entry.
   * 
   * @return The parent Gst::TocEntry of @a entry.
   */
  Glib::RefPtr<Gst::TocEntry> get_parent();
  
  /** Set @a start and @a stop values for the @a entry.
   * 
   * @param start Start value to set.
   * @param stop Stop value to set.
   */
  void set_start_stop_times(gint64 start, gint64 stop);

  
  /** Get start and stop values from the @a entry and write them into appropriate storages.
   * 
   * @param start The storage for the start value, leave #<tt>0</tt> if not need.
   * @param stop The storage for the stop value, leave #<tt>0</tt> if not need.
   * @return <tt>true</tt> if all non-<tt>0</tt> storage pointers were filled with appropriate values,
   * <tt>false</tt> otherwise.
   */
  bool get_start_stop_times(gint64& start, gint64& stop);
  
  /** Get start and stop values from the @a entry and write them into appropriate storages.
   * 
   * @param start The storage for the start value, leave #<tt>0</tt> if not need.
   * @param stop The storage for the stop value, leave #<tt>0</tt> if not need.
   * @return <tt>true</tt> if all non-<tt>0</tt> storage pointers were filled with appropriate values,
   * <tt>false</tt> otherwise.
   */
  bool get_start_stop_times(gint64& start, gint64& stop) const;


};


}


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Toc
   */
  Glib::RefPtr<Gst::Toc> wrap(GstToc* object, bool take_copy = false);

} // namespace Glib


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::TocEntry
   */
  Glib::RefPtr<Gst::TocEntry> wrap(GstTocEntry* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_TOC_H */

