/*
 * @(#)SingleLogFilter.java
 *
 * Copyright (C) 2004 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.util;

import net.sourceforge.groboutils.codecoverage.v2.IChannelLogger;
import net.sourceforge.groboutils.codecoverage.v2.logger.DirectoryChannelLogger;

import java.io.File;
import java.io.IOException;
import java.io.FileReader;


/**
 * Transforms the single logging format to the standard logging format.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2004/07/07 09:39:11 $
 * @since     April 16, 2004
 */
public class SingleLogFilter implements ILogFilter
{
    public void process( int channelCount, File dir )
            throws IOException
    {
//System.out.println("++ Processing single log filter for dir "+dir.getAbsolutePath()+" with "+channelCount+" channels");
        IChannelLogger[] loggers = createChannels( dir, channelCount );
        
        try
        {
            ConvertSingleLog csl = new ConvertSingleLog( loggers );
            File[] contents = dir.listFiles();
            if (contents != null)
            {
                for (int i = 0; i < contents.length; ++i)
                {
                    String name = contents[i].getName();
//System.out.println("++ dir contains "+name);
                    if (contents[i].isFile() && name.startsWith( "single." ) &&
                        name.endsWith( ".log" ))
                    {
//System.out.println("++ it's a log - process it.");
                        FileReader fr = new FileReader( contents[i] );
                        csl.read( fr, true );
                    }
                }
            }
        }
        finally
        {
            cleanupChannels( loggers );
        }
    }
    
    
    protected IChannelLogger[] createChannels( File dir, int count )
    {
        DirectoryChannelLogger[] loggers = new DirectoryChannelLogger[ count ];
        for (int i = 0; i < count; ++i)
        {
            File outdir = new File( dir, Integer.toString( i ) );
            outdir.mkdirs();
//System.out.println("++ channel "+i+" outputting to dir "+outdir.getAbsolutePath());
            loggers[i] = new DirectoryChannelLogger( outdir );
        }
        return loggers;
    }

    protected void cleanupChannels( IChannelLogger[] loggers )
    {
        DirectoryChannelLogger[] dcl = (DirectoryChannelLogger[])loggers;
        
        // Need to somehow clean up these loggers.
    }
}

