/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import sun.io.Markable;
import sun.io.MarkableReader;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private boolean closed = false;
    private boolean reachEOF = false;
    private MarkableReader reader;
    boolean usesDefaultInflater = false;
    private byte[] singleByteBuf = new byte[1];
    private byte[] b = new byte[512];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        super(inputStream);
        if (inputStream == null || inflater == null) {
            throw new NullPointerException();
        }
        if (n <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.inf = inflater;
        this.reader = new MarkableReader(new NativeReader());
        this.buf = new byte[n];
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream) {
        this(inputStream, new Inflater());
        this.usesDefaultInflater = true;
    }

    public int read() throws IOException {
        this.ensureOpen();
        return this.read(this.singleByteBuf, 0, 1) == -1 ? -1 : this.singleByteBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.reader.read(byArray, n, n2);
    }

    public int available() throws IOException {
        this.ensureOpen();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    public long skip(long l) throws IOException {
        int n;
        int n2;
        if (l < 0L) {
            throw new IllegalArgumentException("negative skip length");
        }
        this.ensureOpen();
        int n3 = (int)Math.min(l, Integer.MAX_VALUE);
        for (n = 0; n < n3; n += n2) {
            n2 = n3 - n;
            if (n2 > this.b.length) {
                n2 = this.b.length;
            }
            if ((n2 = this.read(this.b, 0, n2)) != -1) continue;
            this.reachEOF = true;
            break;
        }
        return n;
    }

    public void close() throws IOException {
        if (!this.closed) {
            if (this.usesDefaultInflater) {
                this.inf.end();
            }
            this.in.close();
            this.closed = true;
        }
    }

    protected void fill() throws IOException {
        this.ensureOpen();
        this.len = this.in.read(this.buf, 0, this.buf.length);
        if (this.len == -1) {
            throw new EOFException("Unexpected end of ZLIB input stream");
        }
        this.inf.setInput(this.buf, 0, this.len);
    }

    public synchronized void mark(int n) {
        this.reader.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.reader.reset();
    }

    public boolean markSupported() {
        return this.reader.markSupported();
    }

    private class NativeReader
    implements Markable {
        private NativeReader() {
        }

        public int readNative(byte[] byArray, int n, int n2) throws IOException {
            InflaterInputStream.this.ensureOpen();
            if ((n | n2 | n + n2 | byArray.length - (n + n2)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            try {
                int n3 = 0;
                while (n2 > 0) {
                    int n4 = InflaterInputStream.this.inf.inflate(byArray, n, n2);
                    if (n4 == 0) {
                        if (InflaterInputStream.this.inf.finished() || InflaterInputStream.this.inf.needsDictionary()) {
                            InflaterInputStream.this.reachEOF = true;
                            if (n3 > 0) {
                                return n3;
                            }
                            return -1;
                        }
                        if (InflaterInputStream.this.inf.needsInput()) {
                            InflaterInputStream.this.fill();
                        }
                    }
                    n3 += n4;
                    n += n4;
                    n2 -= n4;
                }
                return n3;
            }
            catch (DataFormatException dataFormatException) {
                String string = dataFormatException.getMessage();
                throw new ZipException(string != null ? string : "Invalid ZLIB data format");
            }
        }
    }
}

