/* pointerHash.h
 */
#ifndef STL_POINTERHASH_H
#define STL_POINTERHASH_H

namespace osl
{
  namespace stl
  {
    template <class T>
    struct hash;
    template <class T> struct hash<T*>
    {
      size_t operator()(const T *pointer) const
      {
	return reinterpret_cast<size_t>(pointer)/8;
      }
    };
  } // namespace stl
} // namespace osl

#endif /* STL_POINTERHASH_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
