package RoPkg::Logger;

use warnings;
use strict;

use RoPkg::Exceptions;

use Class::Singleton;
use Sys::Syslog  qw(:standard :macros);
use Scalar::Util qw(blessed);

use vars qw($VERSION @ISA);

$VERSION = '0.1';
@ISA=qw(Class::Singleton);

sub new {
  shift;
  return RoPkg::Logger->instance(@_);
}

sub instance {
  my ($class, %opt) = @_;
  my $self;

  $self = bless { %opt }, $class;

  if (!$self->{ident}) {
    $self->{ident} = 'wf';
  }
  if (!$self->{options}) {
    $self->{options} = 'ndelay';
  }
  if (!$self->{facility}) {
    $self->{facility} = LOG_USER;
  }

  $self->_init_log();

  return $self;
}

sub _init_log {
  my ($self) = @_;

  return openlog($self->{ident}, $self->{options}, $self->{facility});
}

##############################
### Public methods - BEGIN ###
##############################

sub info {
  my ($self, @items) = @_;

  if ( !blessed($self) ) {
    OutsideClass->throw(
      error    => 'Called outside class instance',
      pkg_name => 'RoPkg::Logger',
    );
  }
  return syslog(LOG_INFO, @items);
}

sub err {
  my ($self, @items) = @_;

  if ( !blessed($self) ) {
    OutsideClass->throw(
      error    => 'Called outside class instance',
      pkg_name => 'RoPkg::Logger',
    );
  }
  return syslog(LOG_ERR, @items);
}

sub alert {
  my ($self, @items) = @_;

  if ( !blessed($self) ) {
    OutsideClass->throw(
      error    => 'Called outside class instance',
      pkg_name => 'RoPkg::Logger',
    );
  }
  return syslog(LOG_ALERT, @items);
}

##############################
###  Public methods -  END ###
##############################

1;
