/***************************************************************************
                          dciconloader.cpp  -  description
                             -------------------
    begin                : Fri Jan 23 2004
    copyright            : (C) 2004 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "dciconloader.h"

#include <qpixmap.h>

#include "icons/gv.xpm"

#include "dcconfig.h"

DCIconLoader * g_pIconLoader = 0;

/** */
DCIconLoader::DCIconLoader()
{
	m_bError = false;

	g_pIconLoader = this;
}

/** */
DCIconLoader::~DCIconLoader()
{
	g_pIconLoader = NULL;

	// clear the map
	m_PixmapMap.clear();
}

/** */
QPixmap DCIconLoader::LoadPixmap( QString file )
{
	QString s,f;
	QPixmap p;
	
	s  = g_pConfig->GetValknutDataPath();
	
	f  = s;
	f += "/icons/appl/";
	f += g_pConfig->GetApplicationIconTheme();
	f += "/";
	f += file;
	if ( p.load(f) )
		return p;
	
	f  = s;
	f += "/icons/appl/default/";
	f += file;
	if ( p.load(f) )
		return p;
	
	printf("DCIconLoader::LoadPixmap: Can't load '%s'\n",file.toAscii().constData());

	m_bError = true;

	p = QPixmap(gv_xpm);

	return p;
}

/** */
bool DCIconLoader::Load()
{
	m_bError = false;

	m_PixmapMap[eiBACK] = LoadPixmap("back.png");
	m_PixmapMap[eiBALL_GREEN] = LoadPixmap("ball_green.png");
	m_PixmapMap[eiBALL_RED] = LoadPixmap("ball_red.png");
	m_PixmapMap[eiBALL_YELLOW] = LoadPixmap("ball_yellow.png");
	m_PixmapMap[eiBOOKMARK_ADD] = LoadPixmap("bookmark_add.png");
	m_PixmapMap[eiBOOKMARK_FOLDER] = LoadPixmap("bookmark_folder.png");
	m_PixmapMap[eiCHOOSE_LANGUAGE] = LoadPixmap("choose-language.png");
	m_PixmapMap[eiCONFIGURE] = LoadPixmap("configure.png");
	m_PixmapMap[eiCONFIGURE_32x32] = LoadPixmap("configure_32x32.png");
	m_PixmapMap[eiCONNECT] = LoadPixmap("connect.png");
	m_PixmapMap[eiCONNECT_CREATING] = LoadPixmap("connect_creating.png");
	m_PixmapMap[eiCONNECT_NO] = LoadPixmap("connect_no.png");
	m_PixmapMap[eiCONNECTED] = LoadPixmap("connected.png");
	m_PixmapMap[eiDOWN] = LoadPixmap("down.png");
	m_PixmapMap[eiDOWNLOAD] = LoadPixmap("download.png");
	m_PixmapMap[eiDOWNLOAD_AS] = LoadPixmap("download_as.png");
	m_PixmapMap[eiEDIT] = LoadPixmap("edit.png");
	m_PixmapMap[eiEDITADD] = LoadPixmap("editadd.png");
	m_PixmapMap[eiEDITCOPY] = LoadPixmap("editcopy.png");
	m_PixmapMap[eiEDITDELETE] = LoadPixmap("editdelete.png");
	m_PixmapMap[eiEMOTICON] = LoadPixmap("emoticon.png");
	m_PixmapMap[eiEXIT] = LoadPixmap("exit.png");
	m_PixmapMap[eiFILECLOSE] = LoadPixmap("fileclose.png");
	m_PixmapMap[eiFILEFIND] = LoadPixmap("filefind.png");
	m_PixmapMap[eiFIND] = LoadPixmap("find.png");
	m_PixmapMap[eiFIND_32x32] = LoadPixmap("find_32x32.png");
	m_PixmapMap[eiFOLDER_BLUE] = LoadPixmap("folder_blue.png");
	m_PixmapMap[eiFOLDER_BLUE_OPEN] = LoadPixmap("folder_blue_open.png");
	m_PixmapMap[eiFOLDER_RED] = LoadPixmap("folder_red.png");
	m_PixmapMap[eiGLOBE] = LoadPixmap("globe.png");
	m_PixmapMap[eiGV] = QPixmap(gv_xpm);
	m_PixmapMap[eiHELP] = LoadPixmap("help.png");
	m_PixmapMap[eiICON_22x22] = LoadPixmap("icon_22x22.png");
	m_PixmapMap[eiINFO] = LoadPixmap("info.png");
	m_PixmapMap[eiMESSAGE] = LoadPixmap("message.png");
	m_PixmapMap[eiNEXT] = LoadPixmap("next.png");
	m_PixmapMap[eiNOTCONNECTED] = LoadPixmap("notconnected.png");
	m_PixmapMap[eiOPEN] = LoadPixmap("open.png");
	m_PixmapMap[eiPLAYER_PAUSE] = LoadPixmap("player_pause.png");
	m_PixmapMap[eiPLAYER_PLAY] = LoadPixmap("player_play.png");
	m_PixmapMap[eiRELOAD] = LoadPixmap("reload.png");
	m_PixmapMap[eiRELOAD_32x32] = LoadPixmap("reload_32x32.png");
	m_PixmapMap[eiSAVE] = LoadPixmap("save.png");
	m_PixmapMap[eiSERVER] = LoadPixmap("server.png");
	m_PixmapMap[eiSORT_DOWN_ARROW] = LoadPixmap("sort-down-arrow.png");
	m_PixmapMap[eiSPLASH] = LoadPixmap("splash.png");
	m_PixmapMap[eiSPY] = LoadPixmap("spy.png");
	m_PixmapMap[eiSSL_NO] = LoadPixmap("ssl_no.png");
	m_PixmapMap[eiSSL_YES] = LoadPixmap("ssl_yes.png");
	m_PixmapMap[eiTEXT_SELECT_ALL] = LoadPixmap("text-select-all.png");
	m_PixmapMap[eiTRANSFER] = LoadPixmap("transfer.png");
	m_PixmapMap[eiTRANSLATE] = LoadPixmap("translate.png");
	m_PixmapMap[eiUP] = LoadPixmap("up.png");
	m_PixmapMap[eiUPDATE] = LoadPixmap("update.png");
	m_PixmapMap[eiUSERS] = LoadPixmap("users.png");
	m_PixmapMap[eiUSERS_32x32] = LoadPixmap("users_32x32.png");
	m_PixmapMap[eiVIEW_SIDETREE] = LoadPixmap("view_sidetree.png");
	m_PixmapMap[eiZOOM_IN] = LoadPixmap("zoom-in.png");
	m_PixmapMap[eiZOOM_OUT] = LoadPixmap("zoom-out.png");
	
	m_PixmapMap[eiFLAG_BOSNIA] = LoadPixmap("flag_bosnia.png");
	m_PixmapMap[eiFLAG_BRAZIL] = LoadPixmap("flag_brazil.png");
	m_PixmapMap[eiFLAG_BRITAIN] = LoadPixmap("flag_britain.png");
	m_PixmapMap[eiFLAG_CZECH] = LoadPixmap("flag_czech.png");
	m_PixmapMap[eiFLAG_DENMARK] = LoadPixmap("flag_denmark.png");
	m_PixmapMap[eiFLAG_FINLAND] = LoadPixmap("flag_finland.png");
	m_PixmapMap[eiFLAG_FRANCE] = LoadPixmap("flag_france.png");
	m_PixmapMap[eiFLAG_GERMANY] = LoadPixmap("flag_germany.png");
	m_PixmapMap[eiFLAG_GREECE] = LoadPixmap("flag_greece.png");
	m_PixmapMap[eiFLAG_HUNGARY] = LoadPixmap("flag_hungary.png");
	m_PixmapMap[eiFLAG_ICELAND] = LoadPixmap("flag_iceland.png");
	m_PixmapMap[eiFLAG_ITALY] = LoadPixmap("flag_italy.png");
	m_PixmapMap[eiFLAG_LATVIA] = LoadPixmap("flag_latvia.png");
	m_PixmapMap[eiFLAG_NETHERLANDS] = LoadPixmap("flag_netherlands.png");
	m_PixmapMap[eiFLAG_NORWAY] = LoadPixmap("flag_norway.png");
	m_PixmapMap[eiFLAG_POLAND] = LoadPixmap("flag_poland.png");
	m_PixmapMap[eiFLAG_ROMANIA] = LoadPixmap("flag_romania.png");
	m_PixmapMap[eiFLAG_RUSSIA] = LoadPixmap("flag_russia.png");
	m_PixmapMap[eiFLAG_SERBIA] = LoadPixmap("flag_serbia.png");
	m_PixmapMap[eiFLAG_SLOVAKIA] = LoadPixmap("flag_slovakia.png");
	m_PixmapMap[eiFLAG_SPAIN] = LoadPixmap("flag_spain.png");
	m_PixmapMap[eiFLAG_SWEDEN] = LoadPixmap("flag_sweden.png");
	
	m_PixmapMap[eiFILETYPE_APPLICATION] = LoadPixmap("filetype-application.png");
	m_PixmapMap[eiFILETYPE_ARCHIVE] = LoadPixmap("filetype-archive.png");
	m_PixmapMap[eiFILETYPE_DOCUMENT] = LoadPixmap("filetype-document.png");
	m_PixmapMap[eiFILETYPE_MP3] = LoadPixmap("filetype-audio.png");
	m_PixmapMap[eiFILETYPE_PICTURE] = LoadPixmap("filetype-picture.png");
	m_PixmapMap[eiFILETYPE_UNKNOWN] = LoadPixmap("filetype-unknown.png");
	m_PixmapMap[eiFILETYPE_VIDEO] = LoadPixmap("filetype-video.png");
	
	return m_bError;
}

/** */
QPixmap & DCIconLoader::GetPixmap( enum eIcons e )
{
	return m_PixmapMap[e];
}
