#import "MockCoderTest.h"

#import <ObjcUnit/MockObjects.h>

@implementation MockCoderTest

- (void)testFailsOnUnexpectedEncodedObject {
    MockCoder *mockCoder = [[[MockCoder alloc] init] autorelease];
    NSException *exception = nil;

    [mockCoder addExpectedEncodedObject:@"Expected"];

    NS_DURING
        [mockCoder encodeObject:@"Not Expected"];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
}

- (void)testFailsOnMissingEncodedObject {
    MockCoder *mockCoder = [[[MockCoder alloc] init] autorelease];
    NSException *exception = nil;

    [mockCoder addExpectedEncodedObject:@"Expected"];

    NS_DURING
        [mockCoder verify];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
}

- (void)testSetDecodedObjects {
    MockCoder *mockCoder = [[[MockCoder alloc] init] autorelease];
    ExpectationList *decodedObjects = [[[ExpectationList alloc] initWithName:@"Decoded Objects"] autorelease];

    [mockCoder addDecodedObject:@"One"];
    [mockCoder addDecodedObject:@"Two"];
    [mockCoder addDecodedObject:@"Three"];

    [decodedObjects addExpectedObject:@"One"];
    [decodedObjects addExpectedObject:@"Two"];
    [decodedObjects addExpectedObject:@"Three"];

    [decodedObjects addActualObject:[mockCoder decodeObject]];
    [decodedObjects addActualObject:[mockCoder decodeObject]];
    [decodedObjects addActualObject:[mockCoder decodeObject]];

    [decodedObjects verify];
}

- (void)testFailsOnTooManyDecodeObjectCalls {
    MockCoder *mockCoder = [[[MockCoder alloc] init] autorelease];
    NSException *exception = nil;

    [mockCoder addDecodedObject:@"One"];
    [mockCoder decodeObject];

    NS_DURING
        [mockCoder decodeObject];
    NS_HANDLER
        exception = localException;
    NS_ENDHANDLER

    [self assertNotNil:exception message:@"Should raise exception"];
}

@end
